% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_duration.R
\name{add_duration}
\alias{add_duration}
\title{Add duration variables to panel data}
\usage{
add_duration(
  data,
  y,
  unitID,
  tID,
  freq = "month",
  sort = FALSE,
  ongoing = TRUE,
  slice.last = FALSE
)
}
\arguments{
\item{data}{Data frame representing panel data.}

\item{y}{A binary indicator of the incidence of some event, e.g. a coup.}

\item{unitID}{Name of the variable in the data frame identifying the 
cross-sectional units, e.g. \code{"country"}.}

\item{tID}{Name of the variable in the data frame identifying the time unit, 
preferably as class \code{\link{Date}}. E.g. \code{"year"}.}

\item{freq}{Frequency at which units are measured in \code{tID}. Currently 
yearly, monthly, and daily data are supported, i.e. \code{"year"}, 
\code{"month"}, or \code{"day"}.}

\item{sort}{Sort data by unit and time? Default is \code{FALSE}, i.e. return
data in original order.}

\item{ongoing}{If \code{TRUE}, successive 1's are considered ongoing events
and treated as \code{NA} after the first 1. If \code{FALSE}, successive 1's 
are all treated as failures.}

\item{slice.last}{Set to \code{TRUE} to create a slice of the last time 
period; used with \code{\link{forecast.spdur}}. For compatibility with CRISP 
and ICEWS projects.}
}
\value{
Returns the original data frame with 8 duration-specific additional 
variables:
\item{failure}{Binary indicator of an event.}
\item{ongoing}{Binary indicator for ongoing events, not counting the initial 
failure time.}
\item{end.spell}{Binary indicator for the last observation in a spell, either
due to censoring or failure.}
\item{cured}{Binary indicator for spells that are coded as cured, or immune
from failure. Equal to 1 - \code{atrisk}.}
\item{atrisk}{Binary indicator for spells that are coded as at risk for 
failure. Equal to 1 - \code{cured}.}
\item{censor}{Binary indicator for right-censored spells.}
\item{duration}{\code{t}, counter for how long a spell has survived without
failure.}
\item{t.0}{Starting time for period observed during \code{t}, by default
equals \code{duration} - 1.}
}
\description{
Builds a duration version of a data frame representing panel data.
}
\details{
This function processes a panel data frame by creating a failure 
variable from \code{y} and corresponding duration counter, as well as 
risk/immunity indicators. Supported time resolutions are year, month, and
day, and input data should be (dis-)aggregated to one of these levels.

The returned data frame should have the same number of rows at the original. 
If \code{y} is an indicator of the incidence of some event, rather than an 
onset indicator, then ongoing spells of failure beyond the initial event are 
coded as NA (e.g. 000111 becomes a spell of 0001 NA NA). This is to preserve
compatibility with the base dataset. Note that the order of rows may be 
different though.

There cannot be missing values ("\code{NA}") in any of the key variables 
\code{y}, \code{unitID}, or \code{tID}; they will stop the function.

Furthermore, series that start with an event, e.g. (100), are treated as 
experiencing failure in the first time period. If those events are in fact 
ongoing, e.g. the last year of a war that started before the start time of 
the dataset, they should be dropped manually before using 
\code{buildDuration()}.

\code{t.0} is the starting time of the period of observation at \code{tID}. 
It is by default set as \code{duration - 1} and currently only serves as a 
placeholder to allow future expansion for varying observation times.
}
\examples{
# Yearly data
data <- data.frame(y=c(0,0,0,1,0), 
                   unitID=c(1,1,1,1,1), 
                   tID=c(2000, 2001, 2002, 2003, 2004))
dur.data <- add_duration(data, "y", "unitID", "tID", freq="year")
dur.data

}
\seealso{
\code{\link{panel_lag}} for lagging variables in a panel data frame 
before building duration data.
}
