% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/task_variogram_indic.R
\name{variogram_sews}
\alias{variogram_sews}
\title{Early-Warning signals based on variograms (EXPERIMENTAL)}
\usage{
variogram_sews(mat, model = "sph", nmax = 1e+05, nbins = 32, cutoff = NULL)
}
\arguments{
\item{mat}{A matrix (TRUE/FALSE values) or a list of matrices}

\item{model}{The variogram model to use, either "sph" (for a spherical
model) or "exp" (for an exponential model)}

\item{nmax}{The maximum number of pairs of cells to use when computing the 
variogram}

\item{nbins}{Number of distance bins to use to compute the variogram}

\item{cutoff}{Maximum distance to consider in the variogram. If NULL, then 
a distance equal to one third of the diagonal of the matrix is used}
}
\value{
A list object of class "variogram_sews", that can be displayed 
  using \code{summary()}, \code{plot()}, etc. Significance of values can 
  be tested using \code{\link{indictest}}.
}
\description{
Compute Early-warning signals based on metrics derived 
  form semi-variograms.
}
\details{
During ecosystem degradation and especially before a regime shift occurs in 
  some ecosystems, spatial autocorrelation is expected to increase in a
  landscape. This increase can be measured based on variograms, which
  represent how the difference (variance) between two points in a landscape
  varies as a function of distance. 

The approach used to derive variogram-based EWS is to compute the 
  empirical variogram of a landscape (represented passed as a matrix of 
  values), then fit a variogram model to it. Three 
  parameters are then extracted from the variogram model (see Nijp et al.
  2019 for a visual description of these parameters): 
  \enumerate{ 
    \item The \emph{nugget} (intercept)
    \item The \emph{partial sill}, i.e. the reduction in semivariance at 
      distance zero
    \item The \emph{correlation range}, i.e. the distance at which the 
      relationship between semivariance and distance flattens
  }

Additionally, the \emph{structural variance} is computed as 
  (partial sill)/(nugget + partial sill), wich quantifies whether the 
  data are spatially structured (structural variance of one), or completely 
  unstructured (value of zero). Theoretical work suggests that partial sill,
  correlation range and structural variance should increase before a regime
  shift occurs in an ecosystem (Nijp et al. 2019). 

This function offers to fit a spherical model or 
  an exponential model. The best-fitting model depends on your data, you 
  should try different options and review the fits using
  \code{\link{plot_variogram}}.

Please note that this part of the package is still experimental and deserves 
  more testing.
}
\examples{

\donttest{
serengeti_ews <- variogram_sews(serengeti, 
                                model ="exp")
plot(serengeti_ews, along = serengeti.rain)
summary(serengeti_ews)

plot_variogram(serengeti_ews)

# nulln should be set to a higher values for meaningful results
serengeti_test <- indictest(serengeti_ews, nulln = 9)
plot(serengeti_test) # gray ribbons indicate the null indicator values 
summary(serengeti_test)
}

}
\references{
Nijp, Jelmer J., Arnaud J.A.M. Temme, George A.K. Voorn, Lammert Kooistra,
  Geerten M. Hengeveld, Merel B. Soons, Adriaan J. Teuling, and Jakob
  Wallinga. (2019) Spatial Early Warning Signals for Impending Regime Shifts:
  A Practical Framework for Application in Real-world Landscapes. Global
  Change Biology 25 (6): 1905-21. \doi{10.1111/gcb.14591}
}
\seealso{
\code{\link{raw_structvar}},
  \code{\link{plot_variogram}}, \code{\link{extract_variogram}},
  \code{\link[=predict.variogram_sews_list]{predict}}

\code{\link{indictest}}, to test the significance of indicator values.
}
