% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrs_data_proc.R
\name{match_lineshape}
\alias{match_lineshape}
\title{Apply Voigt line-broadening to match a reference spectrum.}
\usage{
match_lineshape(
  mrs_data,
  ref,
  xlim,
  init_lb = 0.2,
  init_lg = 0.5,
  min_lb = 0,
  max_lb = Inf,
  min_lg = 0,
  max_lg = 1
)
}
\arguments{
\item{mrs_data}{data to be broadened, note the linewidth of this spectrum
must be narrower than the ref spectrum.}

\item{ref}{reference data to match.}

\item{xlim}{spectral region to match, eg c(5.2, 4.1) could be used to match
two water resonances.}

\item{init_lb}{initial value for the amount of line-broadening to apply (Hz).}

\item{init_lg}{initial value for the Lorentz-Gauss lineshape parameter.}

\item{min_lb}{minimum value for the amount of line-broadening to apply (Hz).}

\item{max_lb}{maximum value for the amount of line-broadening to apply (Hz).}

\item{min_lg}{minimum value for the Lorentz-Gauss lineshape parameter.}

\item{max_lg}{maximum value for the Lorentz-Gauss lineshape parameter.}
}
\value{
a list containing the matched mrs_data, difference spectra and
optimisation results.
}
\description{
Apply Voigt line-broadening to match a reference spectrum.
}
