% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{dem_lisbon_raster}
\alias{dem_lisbon_raster}
\title{Elevation in central Lisbon, Portugal}
\format{
A raster dataset containing elevation above sea level
in a 1km bounding box in Lisbon, Portugal.
}
\source{
\url{https://github.com/rspatial/terra/issues/29}
}
\usage{
dem_lisbon_raster
}
\description{
A dataset containing elevation in and around Lisbon
with a geographic resolution of 10m.
The dataset is 200 pixels wide by 133 pixels high, covering
2.7 square kilometres of central Lisbon.
}
\details{
The dataset was acquired by Instituto Superior
Técnico (University of Lisbon) in 2012, covers all the Northern
Metropolitan Area of Lisbon, and has a 10m cell resolution,
when projected at the official Portuguese EPSG: 3763 - TM06/ETRS89.
The dataset was released as an open access dataset with permission from the
University of Lisbon to support this project.
}
\examples{
library(sf)
library(raster)
dim(dem_lisbon_raster)
res(dem_lisbon_raster)
names(dem_lisbon_raster)
plot(dem_lisbon_raster)
if (rlang::is_installed("sf")) {
  plot(lisbon_road_network["Avg_Slope"], add = TRUE)
}
}
\keyword{datasets}
