% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree-sequences.R
\name{ts_write}
\alias{ts_write}
\title{Save a tree sequence to a file}
\usage{
ts_write(ts, file)
}
\arguments{
\item{ts}{Tree sequence object loaded by \code{ts_read}}

\item{file}{File to which the tree sequence should be saved}
}
\value{
No return value, called for side effects
}
\description{
Save a tree sequence to a file
}
\examples{
\dontshow{check_dependencies(python = TRUE, quit = TRUE) # dependencies must be present
}
init_env()

# load an example model with an already simulated tree sequence
slendr_ts <- system.file("extdata/models/introgression_slim.trees", package = "slendr")
model <- read_model(path = system.file("extdata/models/introgression", package = "slendr"))

# load the tree sequence
ts <- ts_read(slendr_ts, model)

# save the tree-sequence object to a different location
another_file <- paste(tempfile(), ".trees")
ts_write(ts, another_file)
}
