% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diblasi_bowman.R
\name{diblasi_bowman}
\alias{diblasi_bowman}
\title{Diblasi and Bowman's Test for Heteroskedasticity in a Linear Regression Model}
\usage{
diblasi_bowman(
  mainlm,
  distmethod = c("moment.match", "bootstrap"),
  H = 0.08,
  ignorecov = TRUE,
  B = 500L,
  seed = 1234,
  statonly = FALSE
)
}
\arguments{
\item{mainlm}{Either an object of \code{\link[base]{class}} \code{"lm"}
(e.g., generated by \code{\link[stats]{lm}}), or
a list of two objects: a response vector and a design matrix. The objects
are assumed to be in that order, unless they are given the names
\code{"X"}  and \code{"y"} to distinguish them. The design matrix passed
in a list must begin with a column of ones if an intercept is to be
included in the linear model. The design matrix passed in a list should
not contain factors, as all columns are treated 'as is'. For tests that
use ordinary least squares residuals, one can also pass a vector of
residuals in the list, which should either be the third object or be
named \code{"e"}.}

\item{distmethod}{A character specifying the method by which to estimate
the \eqn{p}-values, either \code{"moment.match"} or \code{"bootstrap"}.}

\item{H}{A hyperparameter denoting the bandwidth matrix in the kernel
function used for weights in nonparametric smoothing. If a double of
length 1 (the default), \code{H} is set to \eqn{h I_{p^\prime}} where
\eqn{h} is the scalar bandwidth value entered and \eqn{I_{p^\prime}}
is the \eqn{p^\prime \times p^\prime} identity matrix (where
\eqn{p^\prime} is the number of columns in the \eqn{X} matrix, excluding
an intercept if present). If a double of length \eqn{p^\prime}, \code{H}
is set to \eqn{diag(h)} where \eqn{h} is the bandwidth vector entered.
If \code{H} is a \eqn{p^\prime\times p^\prime} matrix it is used as is.
Any other dimensionality of \code{H} results in an error.}

\item{ignorecov}{A logical. If \code{TRUE} (the default), the
variance-covariance matrix of \eqn{s} is assumed to be diagonal. (This
assumption is, strictly speaking, invalid, but usually yields a reasonable
approximation. Computation time is
prohibitive for large sample sizes if set to \code{FALSE}).}

\item{B}{An integer specifying the number of nonparametric bootstrap
replications to be used, if \code{distmethod="bootstrap"}.}

\item{seed}{An integer specifying a seed to pass to
\code{\link[base]{set.seed}} for random number generation. This allows
reproducibility of bootstrap results. The value \code{NA}
results in not setting a seed.}

\item{statonly}{A logical. If \code{TRUE}, only the test statistic value
is returned, instead of an object of \code{\link[base]{class}}
\code{"htest"}. Defaults to \code{FALSE}.}
}
\value{
An object of \code{\link[base]{class}} \code{"htest"}. If object is
   not assigned, its attributes are displayed in the console as a
   \code{\link[tibble]{tibble}} using \code{\link[broom]{tidy}}.
}
\description{
This function implements the nonparametric test of
   \insertCite{Diblasi97;textual}{skedastic} for testing for heteroskedasticity
   in a linear regression model.
}
\details{
The test entails undertaking a transformation of the OLS residuals
  \eqn{s_i=\sqrt{|e_i|}-E_0(\sqrt{|e_i|})}, where \eqn{E_0} denotes
  expectation under the null hypothesis of homoskedasticity. The kernel
  method of nonparametric regression is used to fit the relationship
  between these \eqn{s_i} and the explanatory variables. This leads to a
  test statistic \eqn{T} that is a ratio of quadratic forms involving the
  vector of \eqn{s_i} and the matrix of normal kernel weights. Although
  nonparametric in its method of fitting the possible heteroskedastic
  relationship, the distributional approximation used to compute
  \eqn{p}-values assumes normality of the errors.
}
\examples{
mtcars_lm <- lm(mpg ~ wt + qsec + am, data = mtcars)
diblasi_bowman(mtcars_lm)
\donttest{diblasi_bowman(mtcars_lm, ignorecov = FALSE)}
diblasi_bowman(mtcars_lm, distmethod = "bootstrap")

}
\references{
{\insertAllCited{}}
}
