% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manage.R
\name{get_contents}
\alias{get_contents}
\title{Get the contents of a simulator directory}
\usage{
get_contents(dir = ".", out_loc = "out")
}
\arguments{
\item{dir}{name of the directory where directory named "files" exists}

\item{out_loc}{a length-1 character vector that gives location
(relative to model's path) that method outputs are stored.This can be
useful for staying organized when multiple simulations are based on
the same Model and Draws objects.  Usually this is just "out"}
}
\description{
This function gives detailed information about what is being stored in the
"files" directory.  In particular, it gives the complete paths for all the
draws, outputs, and evals files.  This can be useful in situations in which
the draws or outputs files are no longer needed and take up a lot of memory.
In such a case a user could delete these files with a command such as
\code{system(paste(c("rm", contents$out_files), collapse = " "))}.
That said, one must be cautious in deleting these files since the
simulator generally assumes that earlier stages' files will be available
and so deleting these may cause errors.  However, if one is essentially
finished with a simulation and evaluated metrics have been computed and if
the methods' raw outputs are taking up a lot of disk space, then one might
consider deleting the out_files (and/or the draws_files).
}
