% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict-biomass.R
\name{eq_biomass_ruiz_peinado_2012}
\alias{eq_biomass_ruiz_peinado_2012}
\title{Biomass equations for Spanish hardwood species}
\usage{
eq_biomass_ruiz_peinado_2012(species, component = "stem", return_rmse = FALSE)
}
\arguments{
\item{species}{A character string specifying the scientific name of the tree
species. It can be a column name if all the species are included in this model.
See Details for available species.}

\item{component}{A character string specifying the tree component for biomass
calculation (e.g., "tree", "stem", "branches"). See Details.}

\item{return_rmse}{A logical value. If TRUE, the function returns the root
mean squared error (RMSE) of the selected model instead of the biomass value.}
}
\value{
A S7 list of parameters
}
\description{
Allometric equations adjusted for Spanish hardwood species
}
\details{
Users can check the list of supported species and their corresponding components
in \link{biomass_models}.
}
\examples{
## get model parameters for silv_predict_biomass
eq_biomass_ruiz_peinado_2012("Quercus suber")
}
\seealso{
\code{\link[=silv_predict_biomass]{silv_predict_biomass()}}, \link{biomass_models}, \code{\link[=eq_biomass_montero_2005]{eq_biomass_montero_2005()}}, \code{\link[=eq_biomass_dieguez_aranda_2009]{eq_biomass_dieguez_aranda_2009()}}
\code{\link[=eq_biomass_ruiz_peinado_2011]{eq_biomass_ruiz_peinado_2011()}}, \code{\link[=eq_biomass_manrique_2017]{eq_biomass_manrique_2017()}}, \code{\link[=eq_biomass_menendez_2022]{eq_biomass_menendez_2022()}},
\code{\link[=eq_biomass_cudjoe_2024]{eq_biomass_cudjoe_2024()}}
}
