% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred_funs.R
\name{forecast_shrinkTVP}
\alias{forecast_shrinkTVP}
\title{Draw from posterior predictive density of a fitted TVP model}
\usage{
forecast_shrinkTVP(mod, newdata, n.ahead)
}
\arguments{
\item{mod}{an object of class \code{shrinkTVP}, containing the fitted model.}

\item{newdata}{a data frame containing the future covariates. The names of the covariates
have to match the names used during model estimation in the call to \code{shrinkTVP}.}

\item{n.ahead}{a single, positive integer indicating the forecasting horizon, i.e. how many time-points into the future
the posterior predictive distribution should be sampled from. Can not be larger than the number of rows in \code{newdata}.}
}
\value{
The value returned is a list object of class \code{shrinkTVP_forc} containing the samples from the
posterior predictive density.
}
\description{
\code{forecast_shrinkTVP} draws from the posterior predictive distribution of a fitted TVP model resulting from a call to
\code{shrinkTVP}.
}
\examples{
\donttest{
# Simulate data
set.seed(123)
sim <- simTVP(theta = c(0.2, 0, 0), beta_mean = c(1.5, -0.3, 0))
data <- sim$data

# Estimate model
res <- shrinkTVP(y ~ x1 + x2, data = data[1:190, ])

# Forecast
forc <- forecast_shrinkTVP(res, data[191:200, ])

# Plot
plot(forc)
}

}
\seealso{
Other prediction functions: 
\code{\link{LPDS}()},
\code{\link{eval_pred_dens}()},
\code{\link{fitted.shrinkTVP}()},
\code{\link{predict.shrinkTVP}()},
\code{\link{residuals.shrinkTVP}()}
}
\author{
Peter Knaus \email{peter.knaus@wu.ac.at}
}
\concept{prediction functions}
