% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approach_vaeac.R
\name{vaeac_train_model_auxiliary}
\alias{vaeac_train_model_auxiliary}
\title{Function used to train a \code{vaeac} model}
\usage{
vaeac_train_model_auxiliary(
  vaeac_model,
  optimizer,
  train_dataloader,
  val_dataloader,
  val_iwae_n_samples,
  running_avg_n_values,
  verbose,
  cuda,
  epochs,
  save_every_nth_epoch,
  epochs_early_stopping,
  epochs_start = 1,
  progressr_bar = NULL,
  vaeac_save_file_names = NULL,
  state_list = NULL,
  initialization_idx = NULL,
  n_vaeacs_initialize = NULL,
  train_vlb = NULL,
  val_iwae = NULL,
  val_iwae_running = NULL
)
}
\arguments{
\item{vaeac_model}{A \code{\link[=vaeac]{vaeac()}} object. The \code{vaeac} model this function is to train.}

\item{optimizer}{A \code{\link[torch:optimizer]{torch::optimizer()}} object. See \code{\link[=vaeac_get_optimizer]{vaeac_get_optimizer()}}.}

\item{train_dataloader}{A \code{\link[torch:dataloader]{torch::dataloader()}} containing the training data for the \code{vaeac} model.}

\item{val_dataloader}{A \code{\link[torch:dataloader]{torch::dataloader()}} containing the validation data for the \code{vaeac} model.}

\item{val_iwae_n_samples}{Positive integer (default is \code{25}). The number of generated samples used
to compute the IWAE criterion when validating the vaeac model on the validation data.}

\item{running_avg_n_values}{running_avg_n_values Positive integer (default is \code{5}).
The number of previous IWAE values to include
when we compute the running means of the IWAE criterion.}

\item{verbose}{String vector or NULL.
Controls verbosity (printout detail level) via one or more of \code{"basic"}, \code{"progress"},
\code{"convergence"}, \code{"shapley"} and \code{"vS_details"}.
\code{"basic"} (default) displays basic information about the computation and messages about parameters/checks.
\code{"progress"} displays where in the calculation process the function currently is.
\code{"convergence"} displays how close the Shapley value estimates are to convergence
(only when \code{iterative = TRUE}).
\code{"shapley"} displays intermediate Shapley value estimates and standard deviations (only when \code{iterative = TRUE}),
and the final estimates.
\code{"vS_details"} displays information about the v(S) estimates,
most relevant for \code{approach \%in\% c("regression_separate", "regression_surrogate", "vaeac")}.
\code{NULL} means no printout.
Any combination can be used, e.g., \code{verbose = c("basic", "vS_details")}.}

\item{cuda}{Logical (default is \code{FALSE}). If \code{TRUE}, then the \code{vaeac} model will be trained using cuda/GPU.
If \code{\link[torch:cuda_is_available]{torch::cuda_is_available()}} is \code{FALSE}, we fall back to using the CPU. Using a GPU
for smaller tabular dataset often do not improve the efficiency.
See \code{vignette("installation", package = "torch")} fo help to enable running on the GPU (only Linux and Windows).}

\item{epochs}{Positive integer (default is \code{100}). The number of epochs to train the final vaeac model.
This includes \code{epochs_initiation_phase}, where the default is \code{2}.}

\item{save_every_nth_epoch}{Positive integer (default is \code{NULL}). If provided, then the vaeac model after
every \code{save_every_nth_epoch}th epoch will be saved.}

\item{epochs_early_stopping}{Positive integer (default is \code{NULL}). The training stops if there has been no
improvement in the validation IWAE for \code{epochs_early_stopping} epochs. If the user wants the training process
to be solely based on this training criterion, then \code{epochs} in \code{\link[=explain]{explain()}} should be set to a large
number. If \code{NULL}, then \code{shapr} will internally set \code{epochs_early_stopping = vaeac.epochs} such that early
stopping does not occur.}

\item{epochs_start}{Positive integer (default is \code{1}). At which epoch the training is starting at.}

\item{progressr_bar}{A \code{\link[progressr:progressor]{progressr::progressor()}} object (default is \code{NULL}) to keep track of progress.}

\item{vaeac_save_file_names}{Array of strings containing the save file names for the \code{vaeac} model.}

\item{state_list}{Named list containing the objects returned from \code{\link[=vaeac_get_full_state_list]{vaeac_get_full_state_list()}}.}

\item{initialization_idx}{Positive integer (default is \code{NULL}). The index
of the current \code{vaeac} model in the initialization phase.}

\item{n_vaeacs_initialize}{Positive integer (default is \code{4}). The number of different vaeac models to initiate
in the start. Pick the best performing one after \code{epochs_initiation_phase}
epochs (default is \code{2}) and continue training that one.}

\item{train_vlb}{A \code{\link[torch:torch_tensor]{torch::torch_tensor()}} (default is \code{NULL})
of one dimension containing previous values for the training VLB.}

\item{val_iwae}{A \code{\link[torch:torch_tensor]{torch::torch_tensor()}} (default is \code{NULL})
of one dimension containing previous values for the validation IWAE.}

\item{val_iwae_running}{A \code{\link[torch:torch_tensor]{torch::torch_tensor()}} (default is \code{NULL})
of one dimension containing previous values for the running validation IWAE.}
}
\value{
Depending on if we are in the initialization phase or not. Then either the trained \code{vaeac} model, or
a list of where the \code{vaeac} models are stored on disk and the parameters of the model.
}
\description{
This function can be applied both in the initialization phase when, we train several initiated \code{vaeac} models, and
to keep training the best performing \code{vaeac} model for the remaining number of epochs. We are in the former setting
when \code{initialization_idx} is provided and the latter when it is \code{NULL}. When it is \code{NULL}, we save the \code{vaeac} models
with lowest VLB, IWAE, running IWAE, and the epochs according to \code{save_every_nth_epoch} to disk.
}
\author{
Lars Henry Berge Olsen
}
\keyword{internal}
