% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strat_poly.R
\name{strat_poly}
\alias{strat_poly}
\title{Stratify using polygons}
\usage{
strat_poly(
  poly,
  attribute,
  features,
  raster,
  filename = NULL,
  overwrite = FALSE,
  plot = FALSE,
  details = FALSE
)
}
\arguments{
\item{poly}{sf. Input polygon coverage. e.g. - forest resources inventory coverage.}

\item{attribute}{Character. Name of attribute within \code{poly} that will be stratified.}

\item{features}{Vector / list of vectors. Features within \code{attribute}
to guide stratification.}

\item{raster}{spatRaster. Raster template to enable polygon to raster conversion.}

\item{filename}{Character. Path to write stratified raster to disc.}

\item{overwrite}{Logical. Specify whether \code{filename} should be overwritten on disc.}

\item{plot}{Logical. Plots output spatRaster.}

\item{details}{Logical. If \code{FALSE} (default) output is spatRaster object of
stratified polygon attributes. If \code{TRUE} return a list
where \code{$outRaster} is the stratified attributes, \code{$lookUp} is the lookup table
for the stratification, and \code{poly} is the defined polygon \code{attribute} with corresponding
\code{features / strata}}
}
\value{
A spatRaster object.
}
\description{
Stratify based on polygon coverage attributes and features.
}
\examples{
#--- load input metrics raster ---#
raster <- system.file("extdata", "sraster.tif", package = "sgsR")
sraster <- terra::rast(raster)

#--- read polygon coverage ---#
poly <- system.file("extdata", "inventory_polygons.shp", package = "sgsR")
fri <- sf::st_read(poly)

#--- stratify polygon coverage ---#
#--- specify polygon attribute to stratify ---#

attribute <- "NUTRIENTS"

#--- specify features within attribute & how they should be grouped ---#
#--- as a single vector ---#

features <- c("poor", "rich", "medium")

srasterpoly <- strat_poly(
  poly = fri,
  attribute = attribute,
  features = features,
  raster = sraster
)

#--- or as multiple lists ---#

g1 <- "poor"
g2 <- c("rich", "medium")

features <- list(g1, g2)

srasterpoly <- strat_poly(
  poly = fri,
  attribute = attribute,
  features = features,
  raster = sraster,
  details = TRUE
)
}
\seealso{
Other stratify functions: 
\code{\link{strat_breaks}()},
\code{\link{strat_kmeans}()},
\code{\link{strat_map}()},
\code{\link{strat_quantiles}()}
}
\author{
Tristan R.H. Goodbody
}
\concept{stratify functions}
