% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_sgplot.R
\name{use_sgplot}
\alias{use_sgplot}
\title{Use sgplot defaults.}
\usage{
use_sgplot(palette_type = "sg", ..., default_colour = deprecated())
}
\arguments{
\item{palette_type}{Name of palette type to use. Defaults to "sg". For all
available palette types, run \code{available_palette_types()}.}

\item{...}{Arguments passed to \code{sgplot::theme_sg()}.}

\item{default_colour}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use the
\code{palette_type} argument instead.}
}
\value{
NULL. Function is used for side effects of setting default ggplot2
theme, colour palette and geom aesthetics.
}
\description{
Set sgplot theme, colour palette and geom aesthetic
defaults for ggplot2 charts.
}
\examples{
library(ggplot2)

d <- subset(mpg, manufacturer == "ford")

# ggplot2 defaults
ggplot(d, aes(x = model)) + geom_bar()
ggplot(d, aes(x = model, fill = class)) + geom_bar()

# Use sgplot defaults
use_sgplot()
ggplot(d, aes(x = model)) + geom_bar()
ggplot(d, aes(x = model, fill = class, colour = class)) + geom_bar()

# Use sgplot defaults and Social Security Scotland colour palettes
use_sgplot(palette_type = "sss")
ggplot(d, aes(x = model)) + geom_bar()
ggplot(d, aes(x = model, fill = class, colour = class)) + geom_bar()

}
