% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_discrete_sg.R
\name{scale_colour_discrete_sg}
\alias{scale_colour_discrete_sg}
\alias{scale_fill_discrete_sg}
\title{Discrete colour/fill scales for Scottish Government plots}
\usage{
scale_colour_discrete_sg(
  palette = "main",
  palette_type = "sg",
  reverse = FALSE,
  ...
)

scale_fill_discrete_sg(
  palette = "main",
  palette_type = "sg",
  reverse = FALSE,
  ...
)
}
\arguments{
\item{palette}{Name of palette to use; e.g. "main", "sequential", "focus".
Default value is "main".}

\item{palette_type}{Name of palette type to use. Defaults to "sg". For all
available palette types, run \code{available_palette_types()}.}

\item{reverse}{Boolean value to indicate whether the palette should be
reversed.}

\item{...}{Additional arguments passed to scale type.}
}
\value{
ggplot2 discrete colour/fill scale
}
\description{
Discrete colour/fill scales for Scottish Government plots
}
\examples{
library(ggplot2)
library(dplyr)

economics_long \%>\%
  filter(variable \%in\% c("psavert", "uempmed")) \%>\%
  ggplot(aes(x = date, y = value, colour = variable)) +
  geom_line(linewidth = 1) +
  scale_colour_discrete_sg()

d <- subset(mpg, manufacturer == "ford")

ggplot(d, aes(x = class, fill = class)) +
 geom_bar() +
 scale_fill_discrete_sg()

}
