% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STBP-methods.R
\docType{methods}
\name{plot,STBP,missing-method}
\alias{plot,STBP,missing-method}
\alias{plot}
\title{Draws a plot with the sequence of posterior probabilities from a sequential
test of Bayesian posterior probabilities}
\usage{
\S4method{plot}{STBP,missing}(x, y)
}
\arguments{
\item{x}{Created as a result of a call to \code{\link{stbp_simple}} or
\code{\link{stbp_composite}}.}

\item{y}{Unused entry}
}
\value{
A plot with the sequence of posterior probabilities
}
\description{
Method for signature \code{"STBP"} to display resulting probabilities.
}
\examples{
# Testing the hypothesis of a sampled population being greater than trajectory H
H <- c(2, 5, 10, 20, 40, 40, 20, 10, 5, 2)

# Generating sequential samples (n = 3) from a population that is 1 below H
# (H - 1)

countP <- matrix(NA, 3, 10)
set.seed(101)
for(i in 1:10){
  countP[, i] <- rpois(3, lambda = (H[i] - 1))
}

# Running STBP on the sample

test2F <- stbp_composite(data = countP,
                          greater_than = TRUE,
                          hypothesis = H,
                          density_func = "poisson",
                          prior = 0.5,
                          lower_bnd = 0,
                          upper_bnd = Inf,
                          lower_criterion = 0.001,
                          upper_criterion = 0.999)
plot(test2F)

## End (Not run)
}
