% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_edge_color.R
\name{set_edge_color}
\alias{set_edge_color}
\title{Set the Colors of Selected Edges}
\usage{
set_edge_color(semPaths_plot, color_list = NULL)
}
\arguments{
\item{semPaths_plot}{A
\link[qgraph:qgraph]{qgraph::qgraph} object generated by
\link[semPlot:semPaths]{semPlot::semPaths}, or a similar
qgraph object modified by other
\link{semptools} functions.}

\item{color_list}{A named vector or a
list of named list. See the Details
section on how to set this argument.}
}
\value{
A \link[qgraph:qgraph]{qgraph::qgraph} based on
the original one, with colors for
selected edges changed.
}
\description{
Set the colors of
selected edges.
}
\details{
Modified a \link[qgraph:qgraph]{qgraph::qgraph}
object generated by
\link[semPlot:semPaths]{semPlot::semPaths} and change the
colors of selected edges.
\subsection{Setting the value of \code{color_list}}{

This argument can be set in two ways.

For a named vector, the name of an
element should be the path as
specified by \link[lavaan:model.syntax]{lavaan::model.syntax}
or as appeared in
\code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}}.

For example, to change the color of the
path regressing \code{y} on \code{x}, the name
should be \code{"y ~ x"}. To change the
color of the covariance between \code{x1}
and \code{x2}, the name should be \code{"x1 ~~ x2"}. Therefore, \code{c("y ~ x1" = "red", "x1 ~~ x2" = "blue")} changes the
colors of the path from \code{x1} to \code{y}
and the covariance between \code{x1} and
\code{x2} to \code{"red"} and \code{"blue"},
respectively.

The order of the two nodes \emph{may}
matter for covariances. Therefore, if
the attribute of a covariance is not
changed, try switching the order of
the two nodes.

For a list of named lists, each named
list should have three named values:
\code{from}, \code{to}, and \code{new_color}. The
attribute of the edge from \code{from} to
\code{to} will be set to \code{new_color}.

The second approach is no longer
recommended, though kept for backward
compatibility.
}
}
\examples{
mod_pa <-
  'x1 ~~ x2
   x3 ~  x1 + x2
   x4 ~  x1 + x3
  '
fit_pa <- lavaan::sem(mod_pa, pa_example)
lavaan::parameterEstimates(fit_pa)[, c("lhs", "op", "rhs", "est", "pvalue")]
m <- matrix(c("x1",   NA,   NA,
                NA, "x3", "x4",
              "x2",   NA,   NA), byrow = TRUE, 3, 3)
p_pa <- semPlot::semPaths(fit_pa, whatLabels="est",
            style = "ram",
            nCharNodes = 0, nCharEdges = 0,
            layout = m)

my_color_vector <- c("x2 ~~ x1" = "red",
                     "x4 ~ x1" = "blue")

p_pa2v <- set_edge_color(p_pa, my_color_vector)
plot(p_pa2v)

my_color_list <- list(list(from = "x1", to = "x2", new_color = "red"),
                     list(from = "x1", to = "x4", new_color =  "blue"))

p_pa2l <- set_edge_color(p_pa, my_color_list)
plot(p_pa2l)

}
