% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rscripts.R
\name{is_valid_2}
\alias{is_valid_2}
\title{Tests if the two parameter model is valid}
\usage{
is_valid_2(dr, pp, drbound = 1/6)
}
\arguments{
\item{dr}{The double reduction rate.}

\item{pp}{The preferential pairing parameter.}

\item{drbound}{The maximum double reduction rate possible.}
}
\value{
\code{TRUE} if the model is valid, \code{FALSE} otherwise.
}
\description{
There is a dependence on the bounds of two-parameter model. This function
returns TRUE if those bounds are satisfied and FALSE otherwise.
}
\examples{
TOL <- 1e-6
is_valid_2(dr = 1/6, pp = 1/3, drbound = 1/6) # Valid
is_valid_2(dr = 1/6, pp = 1/3 - TOL, drbound = 1/6) # Not valid
is_valid_2(dr = 1/6, pp = 1/3 + TOL, drbound = 1/6) # Not valid


}
\author{
David Gerard
}
