% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{check_deps}
\alias{check_deps}
\title{Utility Functions for searchAnalyzeR Package}
\usage{
check_deps(required_packages, install_missing = FALSE)
}
\arguments{
\item{required_packages}{Character vector of required package names}

\item{install_missing}{Logical, whether to suggest installing missing packages}
}
\value{
Logical vector indicating which packages are available
}
\description{
This file contains general utility functions used throughout the package.
}
\details{
This function checks if required packages are installed using \code{requireNamespace}
to check availability without loading packages. For CRAN compliance, this function
does not automatically install packages.
}
\examples{
# Check if packages are available
required <- c("ggplot2", "dplyr")
availability <- check_deps(required)
print(availability)

# Get suggestions for missing packages
required_with_missing <- c("ggplot2", "dplyr", "nonexistent_package")
availability <- check_deps(required_with_missing, install_missing = TRUE)
print(availability)
}
