% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_dttm_fmt.R
\name{dttm_fmt_to_regex}
\alias{dttm_fmt_to_regex}
\title{Convert a parsed date/time format to regex}
\usage{
dttm_fmt_to_regex(
  fmt,
  fmt_regex = fmt_rg(),
  fmt_c = fmt_cmp(),
  anchored = TRUE
)
}
\arguments{
\item{fmt}{A format string (scalar) to be parsed by \code{patterns}.}

\item{fmt_regex}{A named character vector of regexps, one for each date/time
component.}

\item{anchored}{Whether the final regex should be anchored, i.e. bounded by
\code{"^"} and \code{"$"} for a whole match.}
}
\value{
A string containing a regular expression for matching date/time
components according to a format.
}
\description{
\code{\link[=dttm_fmt_to_regex]{dttm_fmt_to_regex()}} takes a \link[tibble:tibble-package]{tibble} of parsed
date/time format components (as returned by \code{\link[=parse_dttm_fmt]{parse_dttm_fmt()}}), and a
mapping of date/time component formats to regexps and generates a single
regular expression with groups for matching each of the date/time components.
}
\keyword{internal}
