% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise_scores.R
\name{summarise_scores}
\alias{summarise_scores}
\alias{summarize_scores}
\title{Summarise scores as produced by \code{\link[=score]{score()}}}
\usage{
summarise_scores(scores, by = "model", fun = mean, ...)

summarize_scores(scores, by = "model", fun = mean, ...)
}
\arguments{
\item{scores}{An object of class \code{scores} (a data.table with
scores and an additional attribute \code{metrics} as produced by \code{\link[=score]{score()}}).}

\item{by}{Character vector with column names to summarise scores by. Default
is "model", i.e. scores are summarised by the "model" column.}

\item{fun}{A function used for summarising scores. Default is \code{\link[=mean]{mean()}}.}

\item{...}{Additional parameters that can be passed to the summary function
provided to \code{fun}. For more information see the documentation of the
respective function.}
}
\value{
A data.table with summarised scores. Scores are summarised according
to the names of the columns of the original data specified in \code{by}
using the \code{fun} passed to \code{summarise_scores()}.
}
\description{
Summarise scores as produced by \code{\link[=score]{score()}}.

\code{summarise_scores} relies on a way to identify the names of the scores and
distinguish them from columns that denote the unit of a single forecast.
Internally, this is done via a stored attribute, \code{metrics} that stores
the names of the scores. This means, however, that you need to be careful
with renaming scores after they have been produced by \code{\link[=score]{score()}}. If you
do, you also have to manually update the attribute by calling
\code{attr(scores, "metrics") <- new_names}.
}
\examples{
\dontshow{
  data.table::setDTthreads(2) # restricts number of cores used on CRAN
}
library(magrittr) # pipe operator
scores <- example_sample_continuous \%>\%
 as_forecast_sample() \%>\%
 score()

# get scores by model
summarise_scores(scores, by = "model")

# get scores by model and target type
summarise_scores(scores, by = c("model", "target_type"))

# get standard deviation
summarise_scores(scores, by = "model", fun = sd)

# round digits
summarise_scores(scores, by = "model") \%>\%
  summarise_scores(fun = signif, digits = 2)
}
\keyword{scoring}
