% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-scores.R
\name{new_scores}
\alias{new_scores}
\title{Construct an object of class \code{scores}}
\usage{
new_scores(scores, metrics, ...)
}
\arguments{
\item{scores}{A data.table or similar with scores as produced by \code{\link[=score]{score()}}.}

\item{metrics}{A character vector with the names of the scores
(i.e. the names of the scoring rules used for scoring).}

\item{...}{Additional arguments to \code{\link[data.table:as.data.table]{data.table::as.data.table()}}}
}
\value{
An object of class \code{scores}
}
\description{
This function creates an object of class \code{scores} based on a
data.table or similar.
}
\examples{
\dontrun{
df <- data.frame(
  model = "A",
  wis = "0.1"
)
new_scores(df, "wis")
}
}
\keyword{internal}
