% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modifiers.R
\name{mod_nullable}
\alias{mod_nullable}
\title{Allow NA in a predicate}
\usage{
mod_nullable(pred)
}
\arguments{
\item{pred}{A predicate function}
}
\value{
A new predicate that allows NAs
}
\description{
This modifies a predicate function to ignore NAs.
}
\examples{
# The `is_incrementing` predicate will fail if there are NAs
x <- c(1, NA, 3)
is_incrementing(x) # FALSE

is_incrementing_null <- mod_nullable(is_incrementing)
is_incrementing_null(x) # TRUE
}
