% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Read_Write_Data.R
\name{Read_CellBender_h5_Multi_File}
\alias{Read_CellBender_h5_Multi_File}
\title{Load CellBender h5 matrices (corrected) from multiple files}
\usage{
Read_CellBender_h5_Multi_File(
  data_dir = NULL,
  filtered_h5 = TRUE,
  custom_name = NULL,
  sample_list = NULL,
  sample_names = NULL,
  h5_group_name = NULL,
  feature_slot_name = "features",
  parallel = FALSE,
  num_cores = NULL,
  merge = FALSE,
  ...
)
}
\arguments{
\item{data_dir}{Directory containing the .h5 files output by CellBender.}

\item{filtered_h5}{logical (default TRUE).  Will set the shared file name suffix if \code{custom_name} is NULL.}

\item{custom_name}{if file name was customized in CellBender then this parameter should contain the portion
of file name that is shared across all samples.  Must included the ".h5" extension as well.}

\item{sample_list}{a vector of sample names if only specific samples are desired.  If \code{NULL} will
read in all files within \code{data_dir} directory.}

\item{sample_names}{a set of sample names to use for each sample entry in returned list.  If \code{NULL} will
set names to the subdirectory name of each sample.}

\item{h5_group_name}{Name of the group within H5 file that contains count data.  This is only
required if H5 file contains multiple subgroups and non-default names.  Default is \code{NULL}.}

\item{feature_slot_name}{Name of the slot contain feature names/ids.  Must be one of:
"features"(Cell Ranger v3+) or "genes" (Cell Ranger v1/v2 or STARsolo).  Default is "features".}

\item{parallel}{logical (default FALSE) whether or not to use multi core processing to read in matrices}

\item{num_cores}{how many cores to use for parallel processing.}

\item{merge}{logical (default FALSE) whether or not to merge samples into a single matrix or return
list of matrices.  If TRUE each sample entry in list will have cell barcode prefix added.  The prefix
will be taken from \code{sample_names}.}

\item{...}{Extra parameters passed to \code{\link[scCustomize]{Read_CellBender_h5_Mat}}.}
}
\value{
list of sparse matrices
}
\description{
Extract sparse matrix with corrected counts from CellBender h5 output file across multiple samples
within the same directory.
}
\examples{
\dontrun{
base_path <- 'path/to/data/directory'
mat_list <- Read_CellBender_h5_Multi_File(data_dir = base_path)
}

}
\concept{read_&_write}
