% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Object_Utilities.R
\name{Extract_Sample_Meta}
\alias{Extract_Sample_Meta}
\title{Extract sample level meta.data}
\usage{
Extract_Sample_Meta(
  object,
  sample_name = "orig.ident",
  variables_include = NULL,
  variables_exclude = NULL,
  include_all = FALSE
)
}
\arguments{
\item{object}{Seurat or LIGER object}

\item{sample_name}{meta.data column to use as sample.  Output data.frame will contain one row per
level or unique value in this variable.}

\item{variables_include}{\verb{@meta.data} columns to keep in final data.frame.  All other columns will
be discarded.  Default is NULL.}

\item{variables_exclude}{columns to discard in final data.frame.  Many cell level columns are
irrelevant at the sample level (e.g., nFeature_RNA, percent_mito).
\itemize{
\item Default parameter value is \code{NULL} but internally will set to discard nFeature_ASSAY(s),
nCount_ASSAY(s), percent_mito, percent_ribo, percent_mito_ribo, and log10GenesPerUMI.
\item If sample level median values are desired for these type of variables the output of this
function can be joined with output of \code{\link[scCustomize]{Median_Stats}}.
\item Set parameter to \code{include_all = TRUE} to prevent any columns from being excluded.
}}

\item{include_all}{logical, whether or not to include all object meta data columns in output data.frame.
Default is FALSE.}
}
\value{
Returns a data.frame with one row per \code{sample_name}.
}
\description{
Returns a by identity meta.data data.frame with one row per sample.  Useful for downstream
quick view of sample breakdown, meta data table creation, and/or use in pseudobulk analysis
}
\examples{
library(Seurat)
pbmc_small[["batch"]] <- sample(c("batch1", "batch2"), size = ncol(pbmc_small), replace = TRUE)

sample_meta <- Extract_Sample_Meta(object = pbmc_small, sample_name = "orig.ident")

# Only return specific columns from meta data (orig.ident and batch)
sample_meta2 <- Extract_Sample_Meta(object = pbmc_small, sample_name = "orig.ident",
variables_include = "batch")

# Return all columns from meta data
sample_meta3 <- Extract_Sample_Meta(object = pbmc_small, sample_name = "orig.ident",
include_all = TRUE)

}
\concept{get_set_util}
