% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessdb.R
\name{sm_datasets}
\alias{sm_datasets}
\title{Retrieve Datasets Table}
\usage{
sm_datasets(ordered = TRUE)
}
\arguments{
\item{ordered}{logical. \code{TRUE} orders the result in the order data was entered into the database, while \code{FALSE} returns the result in a random order, to the benefit of faster query execution.}
}
\value{
A \code{\link[data.table]{data.table}} with information about the available datasets in the database.
}
\description{
This function pulls and return a table called 'DATASET' from the database.
}
\details{
The 'DATASET' table gives information about the different datasets fetched from different providers at regular intervals.
It provides a unique id for each dataset, the frequency of data, the number of records (datapoints) in each dataset,
the minimum and maximum time coverage, when the dataset was last updated, and information about the data source, provider,
and method of data access.
}
\examples{
\donttest{
sm_datasets()
}
}
\seealso{
\code{\link{sm_datasources}}, \code{\link{sm_series}}, \code{\link{samadb}}
}
