% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixOps.R
\name{matrixOps.rvec}
\alias{matrixOps.rvec}
\title{Matrix Multiplication with Rvecs}
\usage{
\method{matrixOps}{rvec}(x, y)
}
\arguments{
\item{x, y}{Vectors, matrices, or rvecs.}
}
\value{
An rvec, if \code{x} or \code{y}
is an rvec.
}
\description{
Matrix multiplication \code{\%*\%} can be used
with \link[=rvec]{rvecs}. However, in constrast to
standard R vectors, multiplying an rvec
by a matrix does not produce a row or
column vector. Instead it produces an
ordinary rvec, with no dimensions.
}
\examples{
A <- matrix(c(10, 10, 10,
              11, 11, 11),
            nrow = 2, byrow = TRUE)
x <- rvec(list(c(1, 2),
               c(3, 4),
               c(5, 6)))
A \%*\% x

## matrix multiplication with an
## ordinary R matrix produces
## a row or column vector
y <- c(1, 3, 5)
A \%*\% y
}
