% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asset_route.R
\name{asset_route}
\alias{asset_route}
\title{High performance route for serving static files}
\usage{
asset_route(
  at,
  path,
  use_index = TRUE,
  fallthrough = FALSE,
  html_charset = "utf-8",
  headers = list(),
  validation = NULL,
  except = NULL
)
}
\arguments{
\item{at}{The url path to listen to requests on}

\item{path}{The path to the file or directory on the file system}

\item{use_index}{Should an \code{index.html} file be served if present when a
client requests the folder}

\item{fallthrough}{Should requests that doesn't match a file enter the
request loop or have a 404 response send directly}

\item{html_charset}{The charset to report when serving html files}

\item{headers}{A list of headers to add to the response. Will be combined
with the global headers of the app}

\item{validation}{An optional validation pattern. Presently, the only type of
validation supported is an exact string match of a header. For example, if
\code{validation} is \code{'"abc" = "xyz"'}, then HTTP requests must have a
header named \code{abc} (case-insensitive) with the value \code{xyz}
(case-sensitive). If a request does not have a matching header, than httpuv
will give a 403 Forbidden response. If the \code{character(0)} (the
default), then no validation check will be performed.}

\item{except}{One or more url paths that should be excluded from the route.
Requests matching these will enter the standard router dispatch. The paths
are interpreted as subpaths to \code{at}, e.g. the final path to exclude will be
\code{at}+\code{exclude} (see example)}
}
\value{
An \link{AssetRoute} object
}
\description{
An \code{asset_route()} is fundamentally different than the other routes provided
by routr. Conceptually it is akin to \code{\link[=resource_route]{resource_route()}} in that it is used
for serving static file content, but this route circumvents the standard
dispatch entirely (the request never enters the R process). This makes it
extremely fast but also somewhat limited as you can't pass the request
through any middleware. The choice between \code{asset_route()} and
\code{\link[=resource_route]{resource_route()}} thus depends on your needs.
}
\examples{
asset_route("/wd", "./", except = "/private")


}
\seealso{
Other Route constructors: 
\code{\link{openapi_route}()},
\code{\link{resource_route}()},
\code{\link{shared_secret_route}()},
\code{\link{sizelimit_route}()}
}
\concept{Route constructors}
