test_that("multiple_value_key()", {
  expect_equal({
    tb <- unique(ft[, c('WEEK', 'Week Ending Date')])
    multiple_value_key(tb)
  }, structure(
    list(
      WEEK = c(
        "2",
        "2",
        "3",
        "3",
        "3",
        "4",
        "4",
        "5",
        "5",
        "7",
        "7",
        "8",
        "8",
        "9",
        "9"
      ),
      `Week Ending Date` = c(
        "01/13/1962",
        "01/11/1964",
        "01/18/1964",
        "01/20/1962",
        "01/19/1963",
        "01/27/1962",
        "01/26/1963",
        "02/03/1962",
        "02/01/1964",
        "02/17/1962",
        "02/16/1963",
        "02/24/1962",
        "02/23/1963",
        "03/03/1962",
        "02/29/1964"
      )
    ),
    row.names = c(NA,-15L),
    class = c("tbl_df", "tbl", "data.frame")
  ))
})

test_that("multiple_value_key()", {
  expect_equal({
    tb <- unique(ft[, c('WEEK', 'Week Ending Date')])
    multiple_value_key(tb, col_as_vector = 'str')
  }, structure(
    list(
      WEEK = c(
        "2",
        "2",
        "3",
        "3",
        "3",
        "4",
        "4",
        "5",
        "5",
        "7",
        "7",
        "8",
        "8",
        "9",
        "9"
      ),
      `Week Ending Date` = c(
        "01/13/1962",
        "01/11/1964",
        "01/18/1964",
        "01/20/1962",
        "01/19/1963",
        "01/27/1962",
        "01/26/1963",
        "02/03/1962",
        "02/01/1964",
        "02/17/1962",
        "02/16/1963",
        "02/24/1962",
        "02/23/1963",
        "03/03/1962",
        "02/29/1964"
      ),
      str = c(
        "c('2', '01/13/1962')",
        "c('2', '01/11/1964')",
        "c('3', '01/18/1964')",
        "c('3', '01/20/1962')",
        "c('3', '01/19/1963')",
        "c('4', '01/27/1962')",
        "c('4', '01/26/1963')",
        "c('5', '02/03/1962')",
        "c('5', '02/01/1964')",
        "c('7', '02/17/1962')",
        "c('7', '02/16/1963')",
        "c('8', '02/24/1962')",
        "c('8', '02/23/1963')",
        "c('9', '03/03/1962')",
        "c('9', '02/29/1964')"
      )
    ),
    row.names = c(NA,-15L),
    class = c("tbl_df", "tbl", "data.frame")
  ))
})
