% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flat_table.R, R/generic.R, R/star_database.R
\name{get_unique_attribute_values.flat_table}
\alias{get_unique_attribute_values.flat_table}
\alias{get_unique_attribute_values}
\alias{get_unique_attribute_values.star_database}
\title{Get unique attribute values}
\usage{
\method{get_unique_attribute_values}{flat_table}(
  db,
  name = NULL,
  attributes = NULL,
  col_as_vector = NULL
)

get_unique_attribute_values(db, name, attributes, col_as_vector)

\method{get_unique_attribute_values}{star_database}(
  db,
  name = NULL,
  attributes = NULL,
  col_as_vector = NULL
)
}
\arguments{
\item{db}{A \code{flat_table} or \code{star_database} object.}

\item{name}{A string, dimension name.}

\item{attributes}{A vector of strings, attribute names.}

\item{col_as_vector}{A string, name of the column to include a vector of values.}
}
\value{
A vector of \code{tibble} objects with unique instances.
}
\description{
Get unique set of values for the given attributes. If no attributes are
indicated, all are considered.
}
\details{
If we work on a star database, a dimension must be indicated.
}
\examples{

instances <- star_database(mrs_cause_schema, ft_num) |>
  get_unique_attribute_values()

instances <- star_database(mrs_cause_schema, ft_num) |>
  get_unique_attribute_values(name = "where")

instances <- star_database(mrs_cause_schema, ft_num) |>
  get_unique_attribute_values("where",
    attributes = c("REGION", "State"))

instances <- flat_table('iris', iris) |>
  get_unique_attribute_values()

}
\seealso{
\code{\link{star_database}}, \code{\link{flat_table}}

Other star database and flat table functions: 
\code{\link{get_attribute_names.flat_table}()},
\code{\link{get_measure_names.flat_table}()},
\code{\link{get_similar_attribute_values.flat_table}()},
\code{\link{get_similar_attribute_values_individually.flat_table}()},
\code{\link{replace_attribute_values.flat_table}()},
\code{\link{set_attribute_names.flat_table}()},
\code{\link{set_measure_names.flat_table}()},
\code{\link{snake_case.flat_table}()}
}
\concept{star database and flat table functions}
