% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rocker-S3-functions.R
\name{rocker-S3-functions}
\alias{rocker-S3-functions}
\title{'rocker' Database Interface R6 Class - S3 functions}
\description{
\link[R6:R6-package]{R6} class interface for handling database connections using \link[DBI:DBI-package]{DBI} package as backend. The class allows handling of connections to e.g. PostgreSQL, MariaDB and SQLite.
Although rocker is a R6 class, functions can be also accesses in classical S3 way.
}
\examples{
# New database handling object
db <- rocker::newDB()
# Setup SQLite database
rocker::setupSQLite(db)
# Open connection
rocker::connect(db)
# Write table
rocker::writeTable(db, "mtcars", mtcars)
# Get query
output <- rocker::getQuery(db, "SELECT * FROM mtcars;")
# Close connection
rocker::disconnect(db)
# Reset database handling object
rocker::unloadDriver(db)
}
\seealso{
Other rocker-S3-functions: 
\code{\link{appendTable}()},
\code{\link{begin}()},
\code{\link{canConnect}()},
\code{\link{clearResult}()},
\code{\link{columnInfo}()},
\code{\link{commit}()},
\code{\link{connect}()},
\code{\link{createTable}()},
\code{\link{disconnect}()},
\code{\link{execute}()},
\code{\link{existsTable}()},
\code{\link{fetch}()},
\code{\link{getInfoCon}()},
\code{\link{getInfoDrv}()},
\code{\link{getInfoRes}()},
\code{\link{getQuery}()},
\code{\link{getRowCount}()},
\code{\link{getRowsAffected}()},
\code{\link{getStatement}()},
\code{\link{hasCompleted}()},
\code{\link{isValidCon}()},
\code{\link{isValidDrv}()},
\code{\link{isValidRes}()},
\code{\link{listFields}()},
\code{\link{listObjects}()},
\code{\link{listTables}()},
\code{\link{readTable}()},
\code{\link{removeTable}()},
\code{\link{rocker-README}},
\code{\link{rocker-package}},
\code{\link{rollback}()},
\code{\link{sendQuery}()},
\code{\link{sendStatement}()},
\code{\link{setupDriver}()},
\code{\link{setupMariaDB}()},
\code{\link{setupPostgreSQL}()},
\code{\link{setupSQLite}()},
\code{\link{unloadDriver}()},
\code{\link{validateCon}()},
\code{\link{writeTable}()}

Other rocker: 
\code{\link{newDB}()},
\code{\link{rocker-R6-class}},
\code{\link{rocker-README}},
\code{\link{rocker-package}}
}
\concept{rocker}
\concept{rocker-S3-functions}
