% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sync_vector.R
\name{sync_vector}
\alias{sync_vector}
\title{Sync (expand or compress) a vector}
\usage{
sync_vector(
  x,
  newLength,
  sep = " ",
  fill = TRUE,
  compressFun = NULL,
  expandFun = NULL,
  compressFunPart = NULL,
  silent = rock::opts$get("silent")
)
}
\arguments{
\item{x}{The vector}

\item{newLength}{The new length}

\item{sep}{When not specifying \code{compressFun} and \code{compressFunPart}, the
\code{paste} function is used to combine elements, and in that case, \code{sep} is
passed to \code{paste} as separator.}

\item{fill}{When expanding streams, whether to duplicate elements to fill
the resulting vector. Ignored if \code{fillFun} is specified.}

\item{compressFun}{If specified, when compressing streams, instead of pasting
elements together using separator \code{sep}, the vectors are passed to function
\code{compressFun}, which must accept a vector (to compress) and a single integer
(with the desired resulting length of the vector).}

\item{expandFun}{If specified, when expanding streams, instead of potentially
filling the new larger vector with elements (if \code{fill} is \code{TRUE}), the
vectors are passed to function \code{expandFun}, which must accept a vector (to
compress) and a single integer (with the desired resulting length of
the vector).}

\item{compressFunPart}{A function to apply to the segments that are
automatically created; this can be passed instead of \code{compressFun}.}

\item{silent}{Whether to be silent or chatty.}
}
\value{
The synced vector
}
\description{
Sync (expand or compress) a vector
}
\examples{
rock::sync_vector(letters[1:10], 15);
rock::sync_vector(letters[1:10], 5);
}
