% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_inductive_code_tree.R
\name{show_inductive_code_tree}
\alias{show_inductive_code_tree}
\title{Show the inductive code tree(s)}
\usage{
show_inductive_code_tree(
  x,
  codes = ".*",
  output = "both",
  headingLevel = 3,
  nodeStyle = list(shape = "box", fontname = "Arial"),
  edgeStyle = list(arrowhead = "none"),
  graphStyle = list(rankdir = "LR")
)
}
\arguments{
\item{x}{A \code{rock_parsedSources} object (the result of a call to
\code{rock::parse_sources}).}

\item{codes}{A regular expression: only code trees from codes coded
with a coding pattern with this name will be shown.}

\item{output}{Whether to show the code tree in the console (\code{text}),
as a plot (\code{plot}), or both (\code{both}).}

\item{headingLevel}{The level of the heading to insert when showing the
code tree as text.}

\item{nodeStyle, edgeStyle, graphStyle}{Arguments to pass on to,
respectively, \code{\link[data.tree:ToDiagrammeRGraph]{data.tree::SetNodeStyle()}}, \code{\link[data.tree:ToDiagrammeRGraph]{data.tree::SetEdgeStyle()}},
and \code{\link[data.tree:ToDiagrammeRGraph]{data.tree::SetGraphStyle()}}.}
}
\value{
\code{x}, invisibly, unless being knitted into R Markdown,
in which case a \code{\link[knitr:asis_output]{knitr::asis_output()}}-wrapped character vector is returned.
}
\description{
This function shows one or more inductive code trees.
}
