% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nodesplit.plot_function.R
\name{nodesplit_plot}
\alias{nodesplit_plot}
\title{End-user-ready results for the node-splitting approach}
\usage{
nodesplit_plot(full, node, drug_names, save_xls)
}
\arguments{
\item{full}{An object of S3 class \code{\link{run_model}}. See 'Value' in
\code{\link{run_model}}.}

\item{node}{An object of S3 class \code{\link{run_nodesplit}}. See 'Value'
in \code{\link{run_nodesplit}}.}

\item{drug_names}{A vector of labels with the name of the interventions in
the order they appear in the argument \code{data} of
\code{\link{run_model}}. If \code{drug_names} is not defined,
the order of the interventions as they appear in \code{data} is used,
instead.}

\item{save_xls}{Logical to indicate whether to export the tabulated results
to an 'xlsx' file (via the \code{\link[writexl:write_xlsx]{write_xlsx}}
function of the R-package
\href{https://CRAN.R-project.org/package=writexl}{writexl}) at the working
directory of the user. The default is \code{FALSE} (do not export).}
}
\value{
\code{nodesplit_plot} returns the following list of elements:
  \item{table_effect_size}{A data-frame with the posterior median,
  posterior standard deviation and 95\% credible interval of the direct and
  indirect effect and the inconsistency factor of each split node.}
  \item{table_model_assessment}{A data-frame with the model assessment
  parameters (DIC, posterior mean of total residual deviance, and number of
  effective parameters), the posterior median, posterior standard deviation
  and 95\% credible interval of \emph{tau} under the consistency model and
  after each split node. See 'Details'.}
  \item{intervalplot_inconsistency_factor}{A panel of interval plots on
  the direct and indirect effect of the split nodes and the corresponding
  inconsistency factor. See 'Details'.}
  \item{intervalplot_tau}{An interval plot on \emph{tau} after each
  split node. See 'Details'.}
}
\description{
\code{nodesplit_plot} hosts a toolkit of functions that
  facilitates the comparison of the consistency model
  (via \code{\link{run_model}}) with the node-splitting approach
  (via \code{\link{run_nodesplit}}) regarding the posterior summaries of the
  direct and indirect effects and inconsistency factor of the split
  nodes, the between-trial standard deviation and model assessment
  parameters (Spiegelhalter et al., 2002) after each split node in the
  network.
}
\details{
\code{intervalplot_inconsistency_factor} includes as many interval
  plots as the number of split nodes in the network. Each interval plot
  illustrates the posterior median and 95\% credible interval of the direct and
  indirect effect of the split nodes and the corresponding inconsistency
  factor.
  The line that corresponds to the inconsistency factor is highlighted with
  green, when it does not cross the vertical line of no difference (between
  the direct and indirect effect), and red otherwise. If there are more than
  30 split nodes, the function presents the interval plots on split nodes
  with conclusive inconsistency factor (green intervals) or those with
  an opposite sign in the direct and indirect effects.

  \code{intervalplot_tau} is an interval plot on the median and 95\% credible
  interval of \emph{tau} after each split node. The lines that correspond to
  the split nodes are sorted in ascending order of the deviance information
  criterion (DIC) which appears at the top of each line.
  The estimated median and 95\% credible intervals of \emph{tau} under the
  consistency model appear in the interval plot as a solid and two dotted
  parallel blue lines, respectively. The different levels of heterogeneity
  appear as green, yellow, orange, and red rectangulars to indicate a low,
  reasonable, fairly high, and fairly extreme heterogeneity, respectively,
  following the classification of Spiegelhalter et al. (2004).
  When a fixed-effect model has been performed, \code{nodesplit_plot} does
  not return the \code{intervalplot_tau}.

  \code{table_model_assessment} also includes the column
  \emph{DIC-based better fit} that indicates the preferred model in terms of
  parsimony for each split node. Therefore, the DIC of the model after each
  split node is compared with the DIC of the consistency model
  (Dias et al., 2010). If the difference in DIC exceeds 5, the consistency
  model is preferred; if the difference in DIC is less than -5, the model
  after the split node is preferred; otherwise, there is little to choose
  between the compared models.

  For a binary outcome, when \code{measure} is "RR" (relative risk) or "RD"
  (risk difference) in \code{\link{run_model}}, \code{nodesplit_plot}
  currently presents the results in the odds ratio scale. This is because,
  the odds ratio is used as the 'best-case' effect measure in
  \code{\link{run_model}}. Then, relative risk, and risk difference are
  obtained as a function of the odds ratio and the selected baseline risk
  (See 'Details' in \code{\link{run_model}}).

  The split nodes have been automatically selected via the
  \code{\link[gemtc:mtc.nodesplit.comparisons]{mtc.nodesplit.comparisons}}
  function of the R-package
  \href{https://CRAN.R-project.org/package=gemtc}{gemtc}.
  See 'Details' in \code{\link{run_nodesplit}}.

  Furthermore, \code{nodesplit_plot} exports both data-frames to separate
  'xlsx' files (via the \code{\link[writexl:write_xlsx]{write_xlsx}} function
  of the R-package
  \href{https://CRAN.R-project.org/package=writexl}{writexl}) to the working
  directory of the user.

  \code{nodesplit_plot} can be used only for a network of interventions and
  when there is at least one split node. Otherwise, the execution of the
  function will be stopped and an error message will be printed on the R
  console.
}
\examples{
data("nma.baker2009")

# Read results from 'run_model' (using the default arguments)
res <- readRDS(system.file('extdata/res_baker.rds', package = 'rnmamod'))

# Read results from 'run_nodesplit' (using the default arguments)
node <- readRDS(system.file('extdata/node_baker.rds', package = 'rnmamod'))

# The names of the interventions in the order they appear in the dataset
interv_names <- c("placebo", "budesonide", "budesonide plus formoterol",
                  "fluticasone", "fluticasone plus salmeterol",
                  "formoterol", "salmeterol", "tiotropium")

# Plot the results from both models
nodesplit_plot(full = res,
               node = node,
               drug_names = interv_names)

}
\references{
Dias S, Welton NJ, Caldwell DM, Ades AE. Checking consistency in mixed
treatment comparison meta-analysis.
\emph{Stat Med} 2010;\bold{29}(7-8):932--44. doi: 10.1002/sim.3767

Spiegelhalter DJ, Abrams KR, Myles JP. Bayesian approaches to clinical trials
and health-care evaluation. John Wiley and Sons, Chichester, 2004.

Spiegelhalter DJ, Best NG, Carlin BP, van der Linde A. Bayesian measures of
model complexity and fit. \emph{J R Stat Soc B} 2002;\bold{64}(4):583--616.
doi: 10.1111/1467-9868.00353
}
\seealso{
\code{\link[gemtc:mtc.nodesplit.comparisons]{mtc.nodesplit.comparisons}},
  \code{\link{run_model}}, \code{\link{run_nodesplit}},
  \code{\link[writexl:write_xlsx]{write_xlsx}}
}
\author{
{Loukia M. Spineli}
}
