% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forestplot.metareg_function.R
\name{forestplot_metareg}
\alias{forestplot_metareg}
\title{Comparator-specific forest plot for network meta-regression}
\usage{
forestplot_metareg(full, reg, compar, cov_name = "covariate value", drug_names)
}
\arguments{
\item{full}{An object of S3 class \code{\link{run_model}}. See 'Value' in
\code{\link{run_model}}.}

\item{reg}{An object of S3 class \code{\link{run_metareg}}. See 'Value' in
\code{\link{run_metareg}}.}

\item{compar}{A character to indicate the comparator intervention. It must
be any name found in \code{drug_names}.}

\item{cov_name}{A character or text to indicate the name of the covariate.}

\item{drug_names}{A vector of labels with the name of the interventions in
the order they appear in the argument \code{data} of
\code{\link{run_model}}. If \code{drug_names} is not defined,
the order of the interventions as they appear in \code{data} is used,
instead.}
}
\value{
A panel of two forest plots: (1) a forest plot on the effect
  estimates and predictions of comparisons with the selected intervention in
  the network under the network meta-analysis and network meta-regression for
  a specified level or value of the investigated covariate, and (2) a forest
  plot on the posterior mean and 95\% credible interval of SUCRA values of
  the interventions (Salanti et al., 2011).
}
\description{
Provides a forest plot with the posterior median and 95\% credible
  and prediction intervals for comparisons with the selected intervention
  (comparator) in the network under the network meta-analysis \emph{and}
  network meta-regression for a specified level or value of the investigated
  covariate, and a forest plot with the corresponding SUCRA values.
}
\details{
The y-axis of the forest plot on \bold{effect sizes} displays the
  labels of the interventions in the network; the selected intervention that
  comprises the \code{compar} argument is annotated in the plot with the
  label 'Comparator intervention'.
  For each comparison with the selected intervention, the 95\% credible and
  prediction intervals are displayed as overlapping lines. Black lines refer
  to estimation under both analyses. Green and red lines refer to prediction
  under network meta-analysis and network meta-regression, respectively. The
  corresponding numerical results are displayed above each line:
  95\% credible intervals are found in parentheses, and 95\% predictive
  intervals are found in brackets. Odds ratios, relative risks, and ratio of
  means are reported in the original scale after exponentiation of the
  logarithmic scale.

  The y-axis for the forest plot on \bold{SUCRA} values displays the
  labels of the interventions in the network.
  The corresponding numerical results are displayed above each line.
  Three coloured rectangles appear in the forest plot: a red rectangle for
  SUCRA values up to 50\%, a yellow rectangular for SUCRA values between
  50\% and 80\%, and a green rectangle for SUCRA values over 80\%.
  Interventions falling at the green area are considered as the highest
  ranked interventions, whilst interventions falling at the red area are
  considered as the lowest ranked interventions.

  In both plots, the interventions are sorted in the descending order of
  their SUCRA values based on the network meta-analysis.

  \code{forestplot_metareg} is integrated in \code{\link{metareg_plot}}.

  \code{forestplot_metareg} can be used only for a network of interventions.
  In the case of two interventions, the execution of the function will be
  stopped and an error message will be printed on the R console.
}
\references{
Salanti G, Ades AE, Ioannidis JP. Graphical methods and numerical summaries
for presenting results from multiple-treatment meta-analysis: an overview and
tutorial. \emph{J Clin Epidemiol} 2011;\bold{64}(2):163--71.
\doi{10.1016/j.jclinepi.2010.03.016}
}
\seealso{
\code{\link{metareg_plot}}, \code{\link{run_metareg}},
  \code{\link{run_model}}
}
\author{
{Loukia M. Spineli}
}
