% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_data.R
\name{ne_find_vector_data}
\alias{ne_find_vector_data}
\title{Return a dataframe of available vector layers on Natural Earth}
\usage{
ne_find_vector_data(
  scale = 110L,
  category = c("cultural", "physical"),
  getmeta = FALSE
)
}
\arguments{
\item{scale}{The scale of map to return, one of `110`, `50`, `10` or `small`,
`medium`, `large`.}

\item{category}{one of natural earth categories : 'cultural', 'physical'}

\item{getmeta}{whether to get url of the metadata for each layer}
}
\value{
dataframe with two variables: layer and metadata
}
\description{
Checks the Natural Earth Github repository for current vector layers and
provides the file name required in the type argument of ne_download.
}
\details{
Note that the filename of the requested object will be returned if
`load = FALSE`.

If the data is to be loaded into memory (`load = TRUE`), the download will
be handled using the GDAL virtual file system, allowing direct access to the
data without writing it to disk.
}
\examples{
\dontrun{
ne_find_vector_data(scale = 10, category = "physical")
}
}
\seealso{
\code{\link{ne_load}}, pre-downloaded data are available using
  \code{\link{ne_countries}}, \code{\link{ne_states}}. Other geographic data
  are available in the raster package : \code{\link[raster]{getData}}.
}
