% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plotGeneViolin}
\alias{plotGeneViolin}
\alias{plotTotalCountViolin}
\alias{plotGeneDetectedViolin}
\title{Visualize gene expression or cell metadata with violin plot}
\usage{
plotGeneViolin(object, gene, byDataset = TRUE, groupBy = NULL, ...)

plotTotalCountViolin(object, groupBy = "dataset", ...)

plotGeneDetectedViolin(object, groupBy = "dataset", ...)
}
\arguments{
\item{object}{A \linkS4class{liger} object.}

\item{gene}{Character gene names.}

\item{byDataset}{Logical, whether the violin plot should be splitted by
dataset. Default \code{TRUE}.}

\item{groupBy}{Names of available categorical variable in \code{cellMeta}
slot. Use \code{FALSE} for no grouping. Default \code{NULL} looks clustering
result but will not group if no clustering found.}

\item{...}{
  Arguments passed on to \code{\link[=plotCellViolin]{plotCellViolin}}, \code{\link[=.ggCellViolin]{.ggCellViolin}}, \code{\link[=.ggplotLigerTheme]{.ggplotLigerTheme}}
  \describe{
    \item{\code{slot}}{Choose the slot to find the \code{y} variable. See Details.
Default \code{"cellMeta"}.}
    \item{\code{yFunc}}{A function object that expects a vector/factor/data.frame
retrieved by \code{y} as the only input, and returns an object of the same
size, so that the y-axis is replaced by this output. Useful when, for
example, users need to scale the gene expression shown on plot.}
    \item{\code{cellIdx}}{Character, logical or numeric index that can subscribe cells.
Missing or \code{NULL} for all cells.}
    \item{\code{titles}}{Title text. A character scalar or a character vector with as
many elements as multiple plots are supposed to be generated. Default
\code{NULL}.}
    \item{\code{violin,box,dot}}{Logical, whether to add violin plot, box plot or dot
(scatter) plot, respectively. Layers are added in the order of dot, violin,
and violin on the top surface. By default, only violin plot is generated.}
    \item{\code{violinAlpha,boxAlpha}}{Numeric, controls the transparency of layers.
Default \code{0.8}, \code{0.6}, respectively.}
    \item{\code{violinWidth,boxWidth}}{Numeric, controls the width of violin/box
bounding box. Default \code{0.9} and \code{0.4}.}
    \item{\code{dotColor,dotSize}}{Numeric, globally controls the appearance of all
dots. Default \code{"black"} and \code{getOption("ligerDotSize")} (1).}
    \item{\code{xlabAngle}}{Numeric, counter-clockwise rotation angle of X axis label
text. Default \code{45}.}
    \item{\code{raster}}{Logical, whether to rasterize the dot plot. Default \code{NULL}
automatically rasterizes the dot plot when number of total cells to be
plotted exceeds 100,000.}
    \item{\code{seed}}{Random seed for reproducibility. Default \code{1}.}
    \item{\code{legendFillTitle}}{Legend title text for fill aesthetics, often used for
violin, box, bar plots. Default \code{NULL} shows the original variable name.}
    \item{\code{showLegend}}{Whether to show the legend. Default \code{TRUE}.}
    \item{\code{legendPosition}}{Text indicating where to place the legend. Choose from
\code{"top"}, \code{"bottom"}, \code{"left"} or \code{"right"}. Default
\code{"right"}.}
    \item{\code{baseSize}}{One-parameter control of all text sizes. Individual text
element sizes can be controlled by other size arguments. "Title" sizes are
2 points larger than "text" sizes when being controlled by this.}
    \item{\code{titleSize,xTitleSize,yTitleSize,legendTitleSize}}{Size of main title,
axis titles and legend title. Default \code{NULL} controls by
\code{baseSize + 2}.}
    \item{\code{subtitleSize,xTextSize,yTextSize,legendTextSize}}{Size of subtitle text,
axis texts and legend text. Default \code{NULL} controls by \code{baseSize}.}
    \item{\code{panelBorder}}{Whether to show rectangle border of the panel instead of
using ggplot classic bottom and left axis lines. Default \code{FALSE}.}
    \item{\code{colorLabels}}{Character vector for modifying category names in a
color legend. Passed to \code{ggplot2::scale_color_manual(labels)}. Default
\code{NULL} uses original levels of the factor.}
    \item{\code{colorValues}}{Character vector of colors for modifying category colors
in a color legend. Passed to \code{ggplot2::scale_color_manual(values)}.
Default \code{NULL} uses internal selected palette when <= 26 categories are
presented, otherwise ggplot hues.}
    \item{\code{legendNRow,legendNCol}}{Integer, when too many categories in one
variable, arranges number of rows or columns. Default \code{NULL},
automatically split to \code{ceiling(levels(variable)/15)} columns.}
    \item{\code{plotly}}{Whether to use plotly to enable web based interactive browsing
for the plot. Requires installation of package "plotly". Default
\code{FALSE}.}
  }}
}
\value{
ggplot if using a single gene and not splitting by dataset.
Otherwise, list of ggplot.
}
\description{
Visualize gene expression or cell metadata with violin plot
}
\examples{
plotGeneViolin(pbmcPlot, varFeatures(pbmcPlot)[1],
               groupBy = "leiden_cluster")
plotTotalCountViolin(pbmc)
plotGeneDetectedViolin(pbmc, dot = TRUE, box = TRUE, colorBy = "dataset")
}
