% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_bioconductor_data.R,
%   R/get_package_host_info.R
\name{parse_html_version}
\alias{parse_html_version}
\title{Parse HTML Content for Package Versions}
\usage{
parse_html_version(html_content, package_name)

parse_html_version(html_content, package_name)
}
\arguments{
\item{html_content}{A character string containing the HTML content of a CRAN package archive page.}

\item{package_name}{A character string specifying the name of the package to extract version information for.}
}
\value{
A list of lists containing package details such as package name, version, link,
        date, and size. Returns an empty list if no versions are found.

A list of lists, where each sublist contains:
  - `package_name`: package name.
  - `package_version`: package version.
  - `link`: link to the package tarball.
  - `date`: The date associated with the package version.
  - `size`: The size of the package tarball.
}
\description{
This function extracts version information from an HTML page listing
available versions of a Bioconductor package.

This function extracts version information from the HTML content of a CRAN archive page.
}
\examples{
\dontrun{
parse_html_version(html_content, "GenomicRanges")
}
}
\keyword{internal}
