% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{calc_overall_risk_score}
\alias{calc_overall_risk_score}
\title{Calculate overall package risk scores}
\usage{
calc_overall_risk_score(data, default_weights = FALSE)
}
\arguments{
\item{data}{risk metric data}

\item{default_weights}{logical T/F for weights choice}
}
\value{
pkg_score
}
\description{
Calculate overall package risk scores
}
\examples{
\donttest{
data <- list(
  pkg_name = "synapser",
  pkg_version = "0.2.1",
  pkg_source_path = "/tmp/RtmpNpDlUz/temp_file_1fe56774aacc/synapser",
  has_bug_reports_url = 1, 
  has_examples = 1,
  has_maintainer = 1,
  size_codebase = 0.06702413,
  has_news = 0,
  has_source_control = 0,
  has_vignettes = 1,
  has_website = 1,
  news_current = 0,
  export_help = 1,
  export_calc = 0.586281,
  check = .7,
  covr = .1084,
  dep_score = .9706878,
  revdep_score = .1260338
  )
  overall_risk_score <- 
    calc_overall_risk_score(data, 
                            default_weights = TRUE)
}
}
