% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensor_symbols.R
\name{e}
\alias{e}
\title{Levi-Civita epsilon}
\usage{
e(...)
}
\arguments{
\item{...}{Index labels separated by commas optionally prefixed by "+" and "-"
to indicate the index position (upper and lower respectively).
If no prefix is provided, a lower index ("-") is assumed.
This argument uses non-standard evaluation: any R symbol
that is not a reserved keyword can be used.}
}
\value{
A labeled tensor object.
The underlying data will differs depending on
the number of labels provided.
}
\description{
Provides a labeled Levi-Civita epsilon (pseudo) tensor.
The indices are required to be lowered. Otherwise an error is thrown.
}
\examples{
e(i, j)

e(i, j, k)
}
\seealso{
Underlying implementation: \code{\link[calculus:epsilon]{calculus::epsilon()}}

Wikipedia: \href{https://en.wikipedia.org/wiki/Levi-Civita_symbol}{Levi-Civita symbol}

Other tensor symbols: 
\code{\link{d}()}
}
\concept{tensor symbols}
\concept{tensor_symbols}
