% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensor_symbols.R
\name{d}
\alias{d}
\title{Kronecker delta}
\usage{
d(n)
}
\arguments{
\item{n}{The dimension.}
}
\value{
A function that expects index labels (see \code{\link[=.]{.()}}) and returns a
labeled tensor. The underlying data will differs depending on
the number of labels provided.
}
\description{
Provides a labeled generalized Kronecker delta. In the special
case of two labels this represents simply the identity matrix.
The Kronecker delta always has an even number of indices.
Note that the first half of the tensor labels need to be lowered,
while the second half needs upper indices. Otherwise an error is thrown.
}
\examples{
d(3)(i, +j)

d(3)(i, j, +k, +l)
}
\seealso{
Underlying implementation: \code{\link[calculus:delta]{calculus::delta()}}

Wikipedia: \href{https://en.wikipedia.org/wiki/Kronecker_delta#generalized_Kronecker_delta}{Generalized Kronecker delta}

Other tensor symbols: 
\code{\link{e}()}
}
\concept{tensor symbols}
\concept{tensor_symbols}
