% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_msrv.R
\name{use_msrv}
\alias{use_msrv}
\title{Set the minimum supported rust version (MSRV)}
\usage{
use_msrv(version, path = ".", overwrite = FALSE)
}
\arguments{
\item{version}{character scalar, the minimum supported Rust version.}

\item{path}{character scalar, path to folder containing DESCRIPTION file.}

\item{overwrite}{default \code{FALSE}. Overwrites the \code{SystemRequirements} field if already set when \code{TRUE}.}
}
\value{
\code{version}
}
\description{
\code{use_msrv()} sets the minimum supported rust version for your R package.
}
\details{
The minimum supported rust version (MSRV) is determined by the
\code{SystemRequirements} field in a package's \code{DESCRIPTION} file. For example, to
set the MSRV to \verb{1.67.0}, the \code{SystemRequirements} must have
\verb{rustc >= 1.67.0}.

By default, there is no MSRV set. However, some crates have features that
depend on a minimum version of Rust. As of this writing the version of Rust
on CRAN's Fedora machine's is 1.69. If you require a version of Rust that is
greater than that, you must set it in your DESCRIPTION file.

It is also important to note that if CRAN's machines do not meet the
specified MSRV, they will not be able to build a binary of your package. As a
consequence, if users try to install the package they will be required to
have Rust installed as well.

To determine the MSRV of your R package, we recommend installing the
\code{cargo-msrv} cli. You can do so by running \verb{cargo install cargo-msrv}. To
determine your MSRV, set your working directory to \code{src/rust} then run
\verb{cargo msrv}. Note that this may take a while.

For more details, please see
\href{https://github.com/foresterre/cargo-msrv}{cargo-msrv}.
}
\examples{
\dontrun{
use_msrv("1.67.1")
}

}
