% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rl_phylum.R
\name{rl_phylum}
\alias{rl_phylum}
\title{IUCN Red List taxa by phylum}
\usage{
rl_phylum(
  phylum_name = NULL,
  year_published = NULL,
  latest = NULL,
  scope_code = NULL,
  page = 1
)
}
\arguments{
\item{phylum_name}{Character. The phylum name (e.g., "Chordata").
Use \code{\link[=rl_phylum]{rl_phylum()}} to list available phyla.}

\item{year_published}{Optional. Single or numeric vector of years to filter assessments by publication year.}

\item{latest}{Optional. Logical. If \code{TRUE}, return only the latest assessment per species.}

\item{scope_code}{Optional. Integer One or more scope codes to filter assessments.}

\item{page}{Optional. Integer vector. Specify one or more page numbers to fetch.
If \code{NULL} or \code{NA}, all pages will be fetched automatically.}
}
\value{
A tibble (class \code{tbl_df}, \code{tbl}, \code{data.frame}) where each column represents a unique API response JSON key.
If \code{phylum_name = NULL}, the tibble contains available phylum names.
If \code{phylum_name} is provided, the tibble contains assessment data for the specified phylum, year, latest, possibly extincts, and other relevant metadata.
}
\description{
Retrieve species assessments by phylum.
If \code{phylum_name = NULL}, it returns a list of available phyla.
If \code{phylum_name} is provided, it retrieves assessments for species in the specified phylum.
}
\examples{
\dontrun{
# List all available phyla
rl_phylum()

# Get assessments for species in Chordata phylum
rl_phylum(phylum_name = "Chordata")

# Get latest assessments for Arthropoda published in 2020
rl_phylum(
  phylum_name = "Arthropoda",
  year_published = 2020,
  latest = TRUE
)
}
}
