% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rl_biogeographical_realms.R
\name{rl_biogeographical_realms}
\alias{rl_biogeographical_realms}
\title{IUCN Red List biogeographical realms}
\usage{
rl_biogeographical_realms(
  code = NULL,
  year_published = NULL,
  latest = NULL,
  possibly_extinct = NULL,
  possibly_extinct_in_the_wild = NULL,
  scope_code = NULL,
  page = 1
)
}
\arguments{
\item{code}{Numeric or Character. One or more biogeographical realm codes (e.g. \code{0} or \code{"0"}).
Use \code{\link[=rl_biogeographical_realms]{rl_biogeographical_realms()}} to list available realms.}

\item{year_published}{Optional. Single or numeric vector of years to filter assessments by publication year.}

\item{latest}{Optional. Logical. If \code{TRUE}, return only the latest assessment per species.}

\item{possibly_extinct}{Optional. Logical. Filter for species flagged as possibly extinct.}

\item{possibly_extinct_in_the_wild}{Optional. Logical. Filter for species possibly extinct in the wild.}

\item{scope_code}{Optional. Integer One or more scope codes to filter assessments.}

\item{page}{Optional. Integer vector. Specify one or more page numbers to fetch.
If \code{NULL} or \code{NA}, all pages will be fetched automatically.}
}
\value{
A tibble (class \verb{tbl_df``, }tbl\verb{, }data.frame\verb{) where each column represents a unique API response JSON key. If }code = NULL\verb{, the tibble contains available biogeographical realms with columns such as realm code and name. If }code` is provided, the tibble contains assessment data for the specified realm(s), including taxon details,
red list category, year, and other relevant metadata.
}
\description{
Retrieve available biogeographical realms or detailed species assessments for one or more realms.
}
\details{
This function has two modes:
\itemize{
\item If \code{code = NULL}, it returns a list of available biogeographical realms.
\item If \code{code} is provided, it retrieves assessments for the specified realm(s),
optionally filtered by year, extinction status, scope, and page(s).
}

If \code{page} is not specified, the function will automatically paginate over all
available pages for each parameter combination.
}
\examples{
\dontrun{
# List all available biogeographical realms
rl_biogeographical_realms()

# Retrieve all assessments for realm code 0
rl_biogeographical_realms(code = 0)

# Get latest assessments from multiple pages with filters
rl_biogeographical_realms(
  code = 0,
  year_published = c(2020, 2021),
  page = c(1, 2)
)
}

}
