% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_plans.R
\name{redist.plot.trace}
\alias{redist.plot.trace}
\title{Make a traceplot for a summary statistic}
\usage{
redist.plot.trace(plans, qty, district = 1L, ...)
}
\arguments{
\item{plans}{the \code{redist_plans} object.}

\item{qty}{\code{\link[dplyr:dplyr_data_masking]{<data-masking>}} the statistic.}

\item{district}{for \code{redist_plans} objects with multiple districts,
which \code{district} to subset to for plotting. Set to \code{NULL} to
perform no subsetting.}

\item{...}{passed on to \code{\link[ggplot2]{geom_line}}}
}
\value{
A ggplot
}
\description{
For a statistic in a \code{\link{redist_plans}} object,
make a traceplot showing the evolution of the statistic over MCMC iterations.
}
\examples{
library(dplyr)
data(iowa)

iowa_map <- redist_map(iowa, existing_plan = cd_2010, pop_tol = 0.05)
plans <- redist_mergesplit_parallel(iowa_map, nsims = 200, chains = 2, silent = TRUE) \%>\%
    mutate(dem = group_frac(iowa_map, dem_08, dem_08 + rep_08)) \%>\%
    number_by(dem)
redist.plot.trace(plans, dem, district = 1)

}
\concept{plot}
