% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecations.R
\name{redist.multisplits}
\alias{redist.multisplits}
\title{Counts the Number of Counties Split Between 3 or More Districts}
\usage{
redist.multisplits(plans, counties)
}
\arguments{
\item{plans}{A numeric vector (if only one map) or matrix with one row
for each precinct and one column for each map. Required.}

\item{counties}{A vector of county names or county ids.}
}
\value{
integer matrix where each district is a
}
\description{
Counts the total number of counties that are split across more than 2 districts.
}
\examples{
data(iowa)
ia <- redist_map(iowa, existing_plan = cd_2010, total_pop = pop, pop_tol = 0.01)
plans <- redist_smc(ia, 50, silent = TRUE)
#old redist.multisplits(plans, ia$region)
splits_multi(plans, ia, region)
}
\concept{analyze}
