% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createFileRepositoryFolder.R
\name{createFileRepositoryFolder}
\alias{createFileRepositoryFolder}
\alias{createFileRepositoryFolder.redcapApiConnection}
\title{Create a Folder in the File Repository}
\usage{
createFileRepositoryFolder(
  rcon,
  name,
  folder_id = numeric(0),
  dag_id = numeric(0),
  role_id = numeric(0),
  ...
)

\method{createFileRepositoryFolder}{redcapApiConnection}(
  rcon,
  name,
  folder_id = numeric(0),
  dag_id = numeric(0),
  role_id = numeric(0),
  ...
)
}
\arguments{
\item{rcon}{A \code{redcapConnection} object.}

\item{name}{\code{character(1)} The name of the folder. If a folder by
this name already exists, no action will be taken.}

\item{folder_id}{\code{integerish(0/1)}. The ID of the parent folder. When
length is 0, the new folder is placed in the top-level.}

\item{dag_id}{\code{integerish(0/1)} The ID of a data access group. When
provided, access to the folder will be restricted to the DAG.}

\item{role_id}{\code{integerish(0/1)} The ID of a role. When provided,
access to the folder will be restricted to users with that role.}

\item{...}{Arguments to pass to other methods}
}
\value{
Returns a data frame with the columns\tabular{ll}{
    \tab  \cr
   \code{folder_id} \tab The REDCap assigned ID value for the newly created folder. \cr
   \code{name} \tab The name assigned to the folder by the user. \cr
}
}
\description{
This method enables the user to create a folder in the
file repository. The folder created may also be a subfolder of an
existing folder.
}
\examples{
\dontrun{
unlockREDCap(connections = c(rcon = "project_alias"),
             url = "your_redcap_url",
             keyring = "API_KEYs",
             envir = globalenv())

# Create a folder in the top-level directory
createFileRepositoryFolder(rcon,
                           name = "New Folder Name")

# Create a folder in a subfolder
createFileRepositoryFolder(rcon,
                           name = "New Folder Name",
                           folder_id = 12345)

# Create a folder assigned to a Data Access Group
createFileRepositoryFolder(rcon,
                           name = "New Folder Name",
                           dag_id = 678)
}


}
\seealso{
\code{\link[=exportFromFileRepository]{exportFromFileRepository()}}, \cr
\code{\link[=importToFileRepository]{importToFileRepository()}}, \cr
\code{\link[=deleteFromFileRepository]{deleteFromFileRepository()}}, \cr
\code{\link[=exportFileRepository]{exportFileRepository()}}, \cr
\code{\link[=importFileRepository]{importFileRepository()}}, \cr
\code{\link[=deleteFileRepository]{deleteFileRepository()}}, \cr
\code{\link[=exportFileRepositoryListing]{exportFileRepositoryListing()}}
}
