% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aic.R
\name{BIC,rateReg-method}
\alias{BIC,rateReg-method}
\title{Bayesian Information Criterion (BIC)}
\usage{
\S4method{BIC}{rateReg}(object, ...)
}
\arguments{
\item{object}{An object used to dispatch a method.}

\item{...}{More fitted model objects.}
}
\value{
If just one object is provided, a numeric value representing
calculated BIC.
If multiple objects are provided, a data frame with rows
corresponding to the objects and columns \code{df} and \code{BIC},
where \code{df} means degree of freedom,
which is the number of parameters in the fitted model.
}
\description{
\code{BIC,rateReg-method} is an S4 class method calculating
Bayesian information criterion (BIC) or so-called
Schwarz's Bayesian criterion (SBC)
for one or several \code{rateReg} objects,
according to the formula
- 2 * log-likelihood + ln(nObs) * nPar,
where nPar represents the number of parameters in the fitted model
and nObs is the number of observations.
}
\details{
When comparing models fitted by maximum likelihood to the same
data, the smaller the BIC, the better the fit.
\code{help(BIC, stats)} for other details.
}
\examples{
## See examples given in function rateReg.
}
\seealso{
\code{\link{rateReg}} for model fitting;
\code{\link{summary,rateReg-method}} for summary of a fitted model;
\code{\link{AIC,rateReg-method}} for AIC.
}
