% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family-eofs.R, R/op-cdo-eof.R,
%   R/op-cdo-eof3d.R, R/op-cdo-eofspatial.R, R/op-cdo-eoftime.R
\name{eofs}
\alias{eofs}
\alias{cdo_eof}
\alias{cdo_eof3d}
\alias{cdo_eofspatial}
\alias{cdo_eoftime}
\title{Empirical Orthogonal Functions}
\usage{
cdo_eof(ifile, neof = NULL, ofile1 = NULL, ofile2 = NULL)

cdo_eof3d(ifile, neof = NULL, ofile1 = NULL, ofile2 = NULL)

cdo_eofspatial(ifile, neof = NULL, ofile1 = NULL, ofile2 = NULL)

cdo_eoftime(ifile, neof = NULL, ofile1 = NULL, ofile2 = NULL)
}
\arguments{
\item{ifile}{String with the path to the input file.}

\item{neof}{INTEGER - Number of eigen functions}

\item{ofile1, ofile2}{Strings with the path to the output files.}
}
\value{
Operators that output one or more files return a character vector to the
output files.

Operators that output an indefinite number of files return a string with the
basename of the files.

Operatos that don't return filenames return a character vector with the
string output.
}
\description{
This module calculates empirical orthogonal functions of the data in infile as the eigen values of the scatter matrix (covariance matrix) S of the data sample z(t). A more detailed description can be found above.  Please note, that the input data are assumed to be anomalies.  If operator eof is chosen, the EOFs are computed in either time or spatial space, whichever is the fastest. If the user already knows, which computation is faster, the module can be forced to perform a computation in time- or gridspace by using the operators eoftime or eofspatial, respectively. This can enhance performance, especially for very long time series, where the number of timesteps is larger than the number of grid-points. Data in infile are assumed to be anomalies. If they are not, the behavior of this module is not well defined. After execution outfile1 will contain all eigen-values and outfile2 the eigenvectors e_j. All EOFs and eigen-values are computed. However, only the first neof EOFs are written to outfile2. Nonetheless, outfile1 contains all eigen-values.  Missing values are not fully supported. Support is only checked for non-changing masks of missing values in time. Although there still will be results, they are not trustworthy, and a warning will occur. In the latter case we suggest to replace missing values by 0 in infile.
}
\details{
\if{html}{\out{<div class="sourceCode">}}\preformatted{eof         Calculate EOFs in spatial or time space
eoftime     Calculate EOFs in time space
eofspatial  Calculate EOFs in spatial space
eof3d       Calculate 3-Dimensional EOFs in time space
}\if{html}{\out{</div>}}
}
