% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sky_grid_segmentation.R
\name{sky_grid_segmentation}
\alias{sky_grid_segmentation}
\title{Assign sky-grid labels}
\usage{
sky_grid_segmentation(z, a, angle_width, first_ring_different = FALSE)
}
\arguments{
\item{z}{\link[terra:SpatRaster-class]{terra::SpatRaster} generated with \code{\link[=zenith_image]{zenith_image()}}.}

\item{a}{\link[terra:SpatRaster-class]{terra::SpatRaster} generated with \code{\link[=azimuth_image]{azimuth_image()}}.}

\item{angle_width}{numeric vector of length one. Angle in deg that must
divide both 0–360 and 0–90 into an integer number of segments. Retrieve a
set of valid values by running
\code{lapply(c(45, 30, 18, 10), function(a) vapply(0:6, function(x) a/2^x, 1))}.}

\item{first_ring_different}{logical vector of length one. If \code{TRUE}, do not
subdivide the first ring.}
}
\value{
Single-layer \link[terra:SpatRaster-class]{terra::SpatRaster} with integer labels. The
object carries attributes \code{angle_width} and \code{first_ring_different}.
}
\description{
Segment a hemispherical view into equal-angle bins in zenith and azimuth,
assigning each pixel a grid-cell ID.
}
\details{
The intersection of zenith rings and azimuth sectors forms a grid whose cells
are circular trapezoids. By default, IDs encode both components as
\code{sectorID * 1000 + ringID}. If \code{first_ring_different = TRUE}, the zenith ring
is not subdivided.

The code below outputs a comprehensive list of valid values for \code{angle_width}.
For convenience, the column \code{radians_denom} can be used to provide
\code{angle_width} as \code{180 / radians_denom_i}, where \code{radians_denom_i} is a value
taken from \code{radians_denom}.

\if{html}{\out{<div class="sourceCode">}}\preformatted{df <- data.frame(degrees = 90 / 1:180)

deg_to_pi_expr <- function(deg) \{
  frac <- MASS::fractions(deg / 180)
  strsplit(as.character(frac), "/")[[1]][2] \%>\% as.numeric()
\}

df$radians_denom <- sapply(df$degrees, function(deg) deg_to_pi_expr(deg))

z <- zenith_image(10, lens())
a <- azimuth_image(z)
u <- c()
for (i in 1:nrow(df)) \{
  u <- c(u, tryCatch(is((sky_grid_segmentation(z, a,
                            180/df$radians_denom[i])), "SpatRaster"),
                     error = function(e) FALSE))
\}
df <- df[u, ]
df
}\if{html}{\out{</div>}}
}
\examples{
caim <- read_caim()
z <- zenith_image(ncol(caim), lens())
a <- azimuth_image(z)
g <- sky_grid_segmentation(z, a, 15)
plot(g == 24005)
\dontrun{
display_caim(g = g)
}
}
\seealso{
\code{\link[=sky_grid_centers]{sky_grid_centers()}}, \code{\link[=ring_segmentation]{ring_segmentation()}}, \code{\link[=sector_segmentation]{sector_segmentation()}}
}
