% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_rr.R
\name{extract_rr}
\alias{extract_rr}
\title{Extract digital numbers at sky points and normalize by estimated zenith
radiance}
\usage{
extract_rr(r, z, a, sky_points, no_of_points = 3, use_window = TRUE)
}
\arguments{
\item{r}{\link[terra:SpatRaster-class]{terra::SpatRaster}. Raster supplying the DN values; must
share rows and columns with the image used to obtain \code{sky_points}.
DN must be linearly related to radiance. See \code{\link[=read_caim_raw]{read_caim_raw()}}.}

\item{z}{\link[terra:SpatRaster-class]{terra::SpatRaster} generated with \code{\link[=zenith_image]{zenith_image()}}.}

\item{a}{\link[terra:SpatRaster-class]{terra::SpatRaster} generated with \code{\link[=azimuth_image]{azimuth_image()}}.}

\item{sky_points}{\code{data.frame} with columns \code{row} and \code{col} (raster
coordinates).}

\item{no_of_points}{numeric vector of length one or \code{NULL}. Number of
near-zenith points used to estimate the zenith DN using inverse distance
weighting (power = 2). If \code{NULL}, the zenith DN is forced to 1, so \code{rr = dn}.}

\item{use_window}{logical of length one. If \code{TRUE} (default), use a
\eqn{3 \times 3} local mean around each point; if \code{FALSE}, use only the
central pixel.}
}
\value{
List with named elements:
\describe{
\item{\code{zenith_dn}}{numeric. Estimated DN at the zenith.}
\item{\code{sky_points}}{\code{data.frame} with columns \code{row}, \code{col}, \code{a}, \code{z}, \code{dn},
and \code{rr} (pixel location, angular coordinates, extracted DN, and relative
radiance). If \code{no_of_points} is \code{NULL}, \code{zenith_dn = 1} and \code{dn = rr}.}
}
}
\description{
Compute relative radiance at selected sky points by dividing
their digital numbers (DN) by an estimated zenith DN.
}
\examples{
\dontrun{
caim <- read_caim()
z <- zenith_image(ncol(caim), lens())
a <- azimuth_image(z)

# See fit_cie_model() for details on the CSV file
path <- system.file("external/sky_points.csv",
                    package = "rcaiman")
sky_points <- read.csv(path)
sky_points <- sky_points[c("Y", "X")]
colnames(sky_points) <- c("row", "col")
head(sky_points)

plot(caim$Blue)
points(sky_points$col, nrow(caim) - sky_points$row, col = 2, pch = 10)
rr <- extract_rr(caim$Blue, z, a, sky_points, 1)
points(rr$sky_points$col, nrow(caim) - rr$sky_points$row, col = 3, pch = 0)
}
}
