% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniprot_proteomics.R
\name{rba_uniprot_proteomics_hpp_search}
\alias{rba_uniprot_proteomics_hpp_search}
\title{Search HPP Proteomics data in UniProt}
\usage{
rba_uniprot_proteomics_hpp_search(
  accession = NULL,
  taxid = NULL,
  data_source = NULL,
  upid = NULL,
  peptide = NULL,
  unique = NULL,
  ...
)
}
\arguments{
\item{accession}{\href{https://www.uniprot.org/help/accession_numbers}{
UniProtKB primary or secondary accession}(s). You can supply up to 100
accession numbers.}

\item{taxid}{NIH-NCBI \href{https://www.uniprot.org/taxonomy/}{Taxon ID}. You
can supply up to 20 taxon IDs.}

\item{data_source}{Proteomics data source. In addition to manual curation,
UniProt also import PTM annotations from the following databases:
\itemize{
\item \href{https://hupo.org/human-proteome-project/}{"HPP"}
}
Please use `rba_uniprot_proteomics_species()` for more information on
the available data sources for a given species.}

\item{upid}{\href{https://www.uniprot.org/help/proteome_id}{UniProt Proteome
identifier (UPID)}. You can supply up to 100 UPIDs.}

\item{peptide}{Peptide sequence(s). You can supply up to 20 sequences.}

\item{unique}{Logical: Should the results be filtered based on the Peptide's
uniqueness (the fact that a peptide maps to only 1 protein). If TRUE, Only
unique peptides will be returned, if FALSE only un-unique peptides will be
returned; If NULL (default) the results will not be filtered based on this.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s arguments
manual for more information on available options.}
}
\value{
A list Where each element correspond to a UniProt protein and
  proteomics data are organized under the "features"
  sub-list.
}
\description{
Using this function, you can search for HPP (Human Proteome Project)
  proteomics features that has been map to UniProt proteins. You may also
  refine your search with modifiers such as data_source, peptide etc. See
  "Arguments section" for more information.
}
\details{
Note that this is a search function. Thus, you are not required to fill every
argument; You may use whatever combinations of arguments you see fit for your
query.

UniProt categorizes proteomics data sources into three main data categories:
  PTM (Post-Translational Modification), non-PTM, and HPP (Human Proteome
  Project); each with corresponding API endpoints, and thus, rbioapi
  functions.
}
\section{Corresponding API Resources}{
 "GET
  https://www.ebi.ac.uk/proteins/api/proteomics/ptm"
}

\examples{
\donttest{
  rba_uniprot_proteomics_hpp_search(peptide = "NDQVYQPLRDRDDAQYSHLGGNWAR")
}

}
\references{
\itemize{
  \item The UniProt Consortium , UniProt: the Universal Protein
  Knowledgebase in 2025, Nucleic Acids Research, 2024;, gkae1010,
  https://doi.org/10.1093/nar/gkae1010
  \item Andrew Nightingale, Ricardo Antunes, Emanuele Alpi, Borisas Bursteinas,
  Leonardo Gonzales, Wudong Liu, Jie Luo, Guoying Qi, Edd Turner, Maria
  Martin, The Proteins API: accessing key integrated protein and genome
  information, Nucleic Acids Research, Volume 45, Issue W1, 3 July 2017,
  Pages W539–W544, https://doi.org/10.1093/nar/gkx237
  \item \href{https://www.ebi.ac.uk/proteins/api/doc/}{Proteins API
  Documentation}
  \item \href{https://www.uniprot.org/help/publications}{Citations note
  on UniProt website}
  }
}
\seealso{
Other "UniProt - Proteomics": 
\code{\link{rba_uniprot_proteomics_hpp}()},
\code{\link{rba_uniprot_proteomics_non_ptm}()},
\code{\link{rba_uniprot_proteomics_non_ptm_search}()},
\code{\link{rba_uniprot_proteomics_ptm}()},
\code{\link{rba_uniprot_proteomics_ptm_search}()},
\code{\link{rba_uniprot_proteomics_species}()}
}
\concept{"UniProt - Proteomics"}
